/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.formats.utils;

import com.logviewer.formats.utils.LvLayoutCustomTypeNode;
import com.logviewer.formats.utils.LvLayoutNode;
import java.util.Arrays;
import java.util.Comparator;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class LvLayoutFixedTextNode
extends LvLayoutCustomTypeNode
implements LvLayoutNode {
    private final String[] values;

    public LvLayoutFixedTextNode(@NonNull String fieldName, @Nullable String fieldType, String ... values) {
        super(fieldName, fieldType);
        this.values = (String[])values.clone();
        Arrays.sort(this.values, Comparator.comparingInt(s -> -s.length()));
    }

    @Override
    public int parse(String s, int offset, int end) {
        for (String value : this.values) {
            if (offset + value.length() > end || !s.startsWith(value, offset)) continue;
            return offset + value.length();
        }
        return -2147483647;
    }

    @Override
    public LvLayoutFixedTextNode clone() {
        return new LvLayoutFixedTextNode(this.getFieldName(), this.getFieldType(), this.values);
    }
}

