/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.data2.net.server;

import com.logviewer.data2.LogService;
import com.logviewer.data2.net.server.api.RemoteTaskContext;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class RemoteTaskContextImpl<CALL_BACK>
implements RemoteTaskContext<CALL_BACK> {
    private final LogService logService;
    private final BiConsumer<CALL_BACK, Boolean> listener;
    private final Consumer<Throwable> errorListener;
    private boolean closed;

    public RemoteTaskContextImpl(LogService logService, BiConsumer<CALL_BACK, Boolean> listener, Consumer<Throwable> errorListener) {
        this.logService = logService;
        this.listener = listener;
        this.errorListener = errorListener;
    }

    @Override
    public LogService getLogService() {
        return this.logService;
    }

    @Override
    public void send(@Nullable CALL_BACK o) {
        assert (!this.closed);
        this.listener.accept(o, false);
    }

    @Override
    public void sendAndCloseChannel(@Nullable CALL_BACK o) {
        assert (!this.closed);
        this.closed = true;
        this.listener.accept(o, true);
    }

    @Override
    public void sendErrorAndCloseChannel(@NonNull Throwable t) {
        assert (!this.closed);
        this.closed = true;
        this.errorListener.accept(t);
    }
}

