/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.data2.net;

import com.logviewer.data2.FileAttributes;
import com.logviewer.data2.LogFormat;
import com.logviewer.data2.LogPath;
import com.logviewer.data2.LogRecord;
import com.logviewer.data2.LogView;
import com.logviewer.data2.Position;
import com.logviewer.data2.RecordList;
import com.logviewer.data2.RemoteLogChangeListenerService;
import com.logviewer.data2.net.Node;
import com.logviewer.data2.net.RemoteNodeService;
import com.logviewer.data2.net.server.AbstractDataLoaderTask;
import com.logviewer.data2.net.server.LoadContentTask;
import com.logviewer.data2.net.server.LoadOneRecordTask;
import com.logviewer.data2.net.server.RecordLoaderRemoteTask;
import com.logviewer.data2.net.server.RecordSearcherRemoteTask;
import com.logviewer.data2.net.server.TryReadTask;
import com.logviewer.data2.net.server.api.RemoteTaskController;
import com.logviewer.filters.RecordPredicate;
import com.logviewer.utils.Destroyer;
import com.logviewer.utils.LvGsonUtils;
import com.logviewer.utils.Pair;
import com.logviewer.web.session.LogDataListener;
import com.logviewer.web.session.LogProcess;
import com.logviewer.web.session.SearchResult;
import com.logviewer.web.session.Status;
import com.logviewer.web.session.tasks.SearchPattern;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class RemoteLog
implements LogView {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteLog.class);
    private final String logId;
    private final String hostname;
    private final LogPath path;
    private final Node node;
    private final LogFormat format;
    private final String serializedFormat;
    private final RemoteNodeService remoteNodeService;
    private final RemoteLogChangeListenerService remoteLogChangeListenerService;

    public RemoteLog(@NonNull LogPath path, @NonNull LogFormat format, @NonNull String logId, @NonNull String hostname, @NonNull RemoteNodeService remoteNodeService, RemoteLogChangeListenerService remoteLogChangeListenerService) {
        this.path = path;
        this.node = path.getNode();
        assert (this.node != null);
        this.remoteNodeService = remoteNodeService;
        this.remoteLogChangeListenerService = remoteLogChangeListenerService;
        this.logId = logId;
        this.format = format;
        this.hostname = hostname;
        this.serializedFormat = LvGsonUtils.GSON.toJson((Object)format, LogFormat.class);
    }

    @Override
    public String getId() {
        return this.logId;
    }

    @Override
    public LogPath getPath() {
        return this.path;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public LogFormat getFormat() {
        return this.format;
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public LogProcess loadRecords(RecordPredicate filter, int recordCount, Position start, boolean backward, String hash, long sizeLimit, @NonNull LogDataListener listener) {
        return new RemoteLogProcess(this, (AbstractDataLoaderTask)new RecordLoaderRemoteTask(this.path.getFile(), this.serializedFormat, start, backward, hash, LvGsonUtils.GSON.toJson((Object)filter, RecordPredicate.class), recordCount, sizeLimit), (o, error) -> {
            if (error != null) {
                listener.onFinish(new Status((Throwable)error), true);
                return;
            }
            if (o instanceof RecordList) {
                listener.onData((RecordList)o);
            } else if (o instanceof Pair) {
                Pair pair = (Pair)o;
                listener.onFinish((Status)pair.getFirst(), (Boolean)pair.getSecond());
            } else if (o instanceof Throwable) {
                listener.onFinish(new Status((Throwable)o), false);
            } else {
                LOG.error("Unexpected message {}", o);
            }
        });
    }

    @Override
    public LogProcess createRecordSearcher(@NonNull Position start, boolean backward, RecordPredicate recordPredicate, @NonNull String hash, int recordCount, @NonNull SearchPattern searchPattern, @NonNull Consumer<SearchResult> listener) {
        return new RemoteLogProcess(this, (AbstractDataLoaderTask)new RecordSearcherRemoteTask(this.path.getFile(), this.serializedFormat, start, backward, hash, LvGsonUtils.GSON.toJson((Object)recordPredicate, RecordPredicate.class), recordCount, searchPattern), (o, error) -> {
            if (error != null) {
                listener.accept(new SearchResult((Throwable)error));
                return;
            }
            listener.accept((SearchResult)o);
        });
    }

    @Override
    public Destroyer addChangeListener(Consumer<FileAttributes> changeListener) {
        return this.remoteLogChangeListenerService.addListener(this.path, changeListener);
    }

    @Override
    public CompletableFuture<Throwable> tryRead() {
        CompletableFuture<Throwable> res = new CompletableFuture<Throwable>();
        this.remoteNodeService.startTask(this.node, new TryReadTask(this.path.getFile(), this.serializedFormat), (aVoid, error) -> res.complete((Throwable)error));
        return res;
    }

    @Override
    public CompletableFuture<LogRecord> readRecordAt(long offset) {
        CompletableFuture<LogRecord> res = new CompletableFuture<LogRecord>();
        this.remoteNodeService.startTask(this.node, new LoadOneRecordTask(this.path.getFile(), this.serializedFormat, offset), (r, error) -> {
            if (error != null) {
                res.completeExceptionally((Throwable)error);
            } else {
                res.complete((LogRecord)r);
            }
        });
        return res;
    }

    @Override
    public CompletableFuture<Pair<String, Integer>> loadContent(long offset, int length) {
        CompletableFuture<Pair<String, Integer>> res = new CompletableFuture<Pair<String, Integer>>();
        this.remoteNodeService.startTask(this.node, new LoadContentTask(this.path.getFile(), offset, length, this.format.getCharset()), (data, error) -> {
            if (error != null) {
                res.completeExceptionally((Throwable)error);
            } else {
                res.complete((Pair<String, Integer>)data);
            }
        });
        return res;
    }

    public String toString() {
        return this.path.toString();
    }

    private static class RemoteLogProcess<E, T extends AbstractDataLoaderTask<E>>
    implements LogProcess {
        private final RemoteTaskController<T> controller;
        final /* synthetic */ RemoteLog this$0;

        RemoteLogProcess(T task, BiConsumer<E, Throwable> callback) {
            this.this$0 = var1_1;
            this.controller = ((RemoteLog)var1_1).remoteNodeService.createTask(((RemoteLog)var1_1).node, task, callback);
        }

        @Override
        public void start() {
            this.this$0.remoteNodeService.startTask(this.controller);
        }

        @Override
        public void setTimeLimit(long timeLimit) {
            this.controller.alterTask((Consumer<AbstractDataLoaderTask> & Serializable)task -> task.setTimeLimit(timeLimit));
        }

        @Override
        public void cancel() {
            this.controller.cancel();
        }
    }
}

