/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.data2.config;

import com.logviewer.data2.config.ConfigDirHolder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.springframework.core.env.Environment;
import org.springframework.lang.NonNull;

public class ConfigDirHolderImpl
implements ConfigDirHolder {
    public static final String CONFIG_DIR_PROPERTY = "log-viewer.config-dir";
    private final Path configDir;
    private final Environment environment;

    public ConfigDirHolderImpl(Environment environment) {
        this.environment = environment;
        String configDir = environment.getProperty(CONFIG_DIR_PROPERTY);
        if (configDir == null) {
            configDir = System.getProperty("user.home") + "/.log-viewer";
        }
        this.configDir = Paths.get(configDir, new String[0]);
        if (!Files.isDirectory(this.configDir, new LinkOption[0])) {
            try {
                Files.createDirectory(this.configDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create config directory: " + this.configDir, e);
            }
        }
    }

    @Override
    public Path getConfigDir() {
        return this.configDir;
    }

    @Override
    public String getProperty(@NonNull String name) {
        return this.environment.getProperty(name);
    }
}

