/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.data2;

import com.logviewer.data2.LogCrashedException;
import com.logviewer.data2.LogRecord;
import com.logviewer.data2.Snapshot;
import com.logviewer.utils.LvDateUtils;
import com.logviewer.utils.Utils;
import java.io.IOException;
import java.util.Date;
import java.util.function.Predicate;
import org.springframework.lang.NonNull;

public class LogIndex {
    private FindFirstProcessor firstRecord;
    private FindFirstProcessor lastRecord;
    private long size = 0L;

    public LogRecord findRecordBound(@NonNull Date time, boolean lastBound, Snapshot buffer) throws IOException, LogCrashedException {
        return this.findRecordBound(LvDateUtils.toNanos(time), lastBound, buffer);
    }

    public synchronized LogRecord findRecordBound(long time, boolean lastBound, Snapshot buffer) throws IOException {
        boolean useCache;
        FindFirstProcessor lastRecord;
        FindFirstProcessor firstRecord;
        Utils.assertValidTimestamp(time);
        if (this.size > buffer.getSize()) {
            firstRecord = null;
            lastRecord = null;
            useCache = false;
        } else {
            firstRecord = this.firstRecord;
            lastRecord = this.lastRecord;
            useCache = true;
            if (this.size != buffer.getSize()) {
                if (firstRecord != null && (firstRecord.result == null || firstRecord.result.getEnd() >= this.size)) {
                    firstRecord = null;
                }
                this.size = buffer.getSize();
                this.firstRecord = firstRecord;
                lastRecord = null;
                this.lastRecord = null;
            }
        }
        if (firstRecord == null) {
            firstRecord = new FindFirstProcessor();
            buffer.processRecords(0L, false, firstRecord);
            if (useCache) {
                this.firstRecord = firstRecord;
            }
        }
        if (firstRecord.result == null) {
            return null;
        }
        if (lastBound) {
            if (time < firstRecord.result.getTime()) {
                return null;
            }
        } else if (time <= firstRecord.result.getTime()) {
            return firstRecord.result;
        }
        if (lastRecord == null) {
            lastRecord = new FindFirstProcessor();
            buffer.processRecordsBack(buffer.getSize(), false, lastRecord);
            assert (lastRecord.result != null);
            if (useCache) {
                this.lastRecord = lastRecord;
            }
        }
        if (lastBound) {
            if (time >= lastRecord.result.getTime()) {
                return lastRecord.result;
            }
        } else if (time > lastRecord.result.getTime()) {
            return null;
        }
        LogRecord low = firstRecord.result;
        LogRecord high = lastRecord.result;
        while (high.getStart() - low.getEnd() > 8192L) {
            long mid = low.getEnd() + high.getStart() >>> 1;
            FindFirstProcessor processor = new FindFirstProcessor();
            buffer.processRecords(mid, false, processor);
            assert (processor.result != null);
            assert (processor.result.getStart() > low.getStart());
            assert (processor.result.getEnd() < high.getEnd());
            if (low.getTime() > processor.result.getTime()) {
                throw new IOException("Incorrect record order: " + low.getMessage() + " > " + processor.result.getMessage());
            }
            if (high.getTime() < processor.result.getTime()) {
                throw new IOException("Incorrect record order: " + high.getMessage() + " < " + processor.result.getMessage());
            }
            if (lastBound) {
                if (time >= processor.result.getTime()) {
                    low = processor.result;
                    continue;
                }
                high = processor.result;
                continue;
            }
            if (time > processor.result.getTime()) {
                low = processor.result;
                continue;
            }
            high = processor.result;
        }
        LogRecord[] res = new LogRecord[1];
        if (lastBound) {
            buffer.processRecordsBack(high.getStart(), true, r -> {
                if (r.hasTime() && r.getTime() <= time) {
                    res[0] = r;
                    return false;
                }
                return true;
            });
        } else {
            buffer.processRecords(low.getEnd(), true, r -> {
                if (r.hasTime() && r.getTime() >= time) {
                    res[0] = r;
                    return false;
                }
                return true;
            });
        }
        assert (res[0] != null);
        return res[0];
    }

    private static class FindFirstProcessor
    implements Predicate<LogRecord> {
        private LogRecord firstRecordWithoutTime;
        private LogRecord result;

        private FindFirstProcessor() {
        }

        @Override
        public boolean test(LogRecord t) {
            if (this.result != null) {
                throw new IllegalStateException();
            }
            if (t.hasTime()) {
                this.result = t;
                return false;
            }
            if (this.firstRecordWithoutTime == null) {
                this.firstRecordWithoutTime = t;
            }
            return true;
        }
    }
}

