/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.retry.monitoring.endpoint;

import io.github.resilience4j.retry.event.RetryEvent;
import io.github.resilience4j.retry.monitoring.endpoint.RetryEventDTO;

class RetryEventDTOBuilder {
    private final String retryName;
    private final RetryEvent.Type type;
    private final String creationTime;
    private String errorMessage;
    private int numberOfAttempts;

    RetryEventDTOBuilder(String retryName, RetryEvent.Type type, String creationTime) {
        this.retryName = retryName;
        this.type = type;
        this.creationTime = creationTime;
    }

    RetryEventDTOBuilder throwable(Throwable throwable) {
        this.errorMessage = throwable.toString();
        return this;
    }

    RetryEventDTOBuilder numberOfAttempts(int numberOfAttempts) {
        this.numberOfAttempts = numberOfAttempts;
        return this;
    }

    RetryEventDTO build() {
        return new RetryEventDTO(this.retryName, this.type, this.creationTime, this.errorMessage, this.numberOfAttempts);
    }
}

