/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead.monitoring.endpoint;

import io.github.resilience4j.bulkhead.event.BulkheadEvent;
import io.github.resilience4j.bulkhead.monitoring.endpoint.BulkheadEventDTOFactory;
import io.github.resilience4j.bulkhead.monitoring.endpoint.BulkheadEventsEndpointResponse;
import io.github.resilience4j.consumer.CircularEventConsumer;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.vavr.collection.List;
import java.util.Comparator;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;

@Endpoint(id="bulkheadevents")
public class BulkheadEventsEndpoint {
    private final EventConsumerRegistry<BulkheadEvent> eventConsumerRegistry;

    public BulkheadEventsEndpoint(EventConsumerRegistry<BulkheadEvent> eventConsumerRegistry) {
        this.eventConsumerRegistry = eventConsumerRegistry;
    }

    @ReadOperation
    public BulkheadEventsEndpointResponse getAllBulkheadEvents() {
        java.util.List response = this.eventConsumerRegistry.getAllEventConsumer().flatMap(CircularEventConsumer::getBufferedEvents).sorted(Comparator.comparing(BulkheadEvent::getCreationTime)).map(BulkheadEventDTOFactory::createBulkheadEventDTOFactory).toJavaList();
        return new BulkheadEventsEndpointResponse(response);
    }

    @ReadOperation
    public BulkheadEventsEndpointResponse getEventsFilteredByBulkheadName(@Selector String bulkheadName) {
        java.util.List response = this.getBulkheadEvent(bulkheadName).map(BulkheadEventDTOFactory::createBulkheadEventDTOFactory).toJavaList();
        return new BulkheadEventsEndpointResponse(response);
    }

    @ReadOperation
    public BulkheadEventsEndpointResponse getEventsFilteredByBulkheadNameAndEventType(@Selector String bulkheadName, @Selector String eventType) {
        java.util.List response = this.getBulkheadEvent(bulkheadName).filter(event -> event.getEventType() == BulkheadEvent.Type.valueOf((String)eventType.toUpperCase())).map(BulkheadEventDTOFactory::createBulkheadEventDTOFactory).toJavaList();
        return new BulkheadEventsEndpointResponse(response);
    }

    private List<BulkheadEvent> getBulkheadEvent(String bulkheadName) {
        return this.eventConsumerRegistry.getEventConsumer(bulkheadName).getBufferedEvents().filter(event -> event.getBulkheadName().equals(bulkheadName));
    }
}

