/*
 * Decompiled with CFR 0.152.
 */
package io.github.quickmsg.rule.source;

import io.github.quickmsg.common.rule.source.Source;
import io.github.quickmsg.common.rule.source.SourceBean;
import io.github.quickmsg.common.rule.source.SourceDefinition;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SourceManager {
    private static final Map<Source, SourceBean> CACHE_BEANS = new ConcurrentHashMap<Source, SourceBean>();

    public static SourceBean getSourceBean(Source source) {
        return CACHE_BEANS.get(source);
    }

    public static void loadSource(SourceDefinition sourceDefinition) {
        SourceBean.SOURCE_BEAN_LIST.forEach(sourceBean -> {
            if (sourceBean.support(sourceDefinition.getSource()).booleanValue() && sourceBean.bootstrap(sourceDefinition.getSourceAttributes()).booleanValue()) {
                CACHE_BEANS.put(sourceDefinition.getSource(), (SourceBean)sourceBean);
            }
        });
    }
}

