/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.common.dto;

import com.dtp.common.dto.Metrics;

public class ThreadPoolStats
extends Metrics {
    private String dtpName;
    private int corePoolSize;
    private int maximumPoolSize;
    private String queueType;
    private int queueCapacity;
    private int queueSize;
    private boolean fair;
    private int queueRemainingCapacity;
    private int activeCount;
    private long taskCount;
    private long completedTaskCount;
    private int largestPoolSize;
    private int poolSize;
    private int waitTaskCount;
    private int rejectCount;
    private String rejectHandlerName;

    ThreadPoolStats(String dtpName, int corePoolSize, int maximumPoolSize, String queueType, int queueCapacity, int queueSize, boolean fair, int queueRemainingCapacity, int activeCount, long taskCount, long completedTaskCount, int largestPoolSize, int poolSize, int waitTaskCount, int rejectCount, String rejectHandlerName) {
        this.dtpName = dtpName;
        this.corePoolSize = corePoolSize;
        this.maximumPoolSize = maximumPoolSize;
        this.queueType = queueType;
        this.queueCapacity = queueCapacity;
        this.queueSize = queueSize;
        this.fair = fair;
        this.queueRemainingCapacity = queueRemainingCapacity;
        this.activeCount = activeCount;
        this.taskCount = taskCount;
        this.completedTaskCount = completedTaskCount;
        this.largestPoolSize = largestPoolSize;
        this.poolSize = poolSize;
        this.waitTaskCount = waitTaskCount;
        this.rejectCount = rejectCount;
        this.rejectHandlerName = rejectHandlerName;
    }

    public static ThreadPoolStatsBuilder builder() {
        return new ThreadPoolStatsBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThreadPoolStats)) {
            return false;
        }
        ThreadPoolStats other = (ThreadPoolStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCorePoolSize() != other.getCorePoolSize()) {
            return false;
        }
        if (this.getMaximumPoolSize() != other.getMaximumPoolSize()) {
            return false;
        }
        if (this.getQueueCapacity() != other.getQueueCapacity()) {
            return false;
        }
        if (this.getQueueSize() != other.getQueueSize()) {
            return false;
        }
        if (this.isFair() != other.isFair()) {
            return false;
        }
        if (this.getQueueRemainingCapacity() != other.getQueueRemainingCapacity()) {
            return false;
        }
        if (this.getActiveCount() != other.getActiveCount()) {
            return false;
        }
        if (this.getTaskCount() != other.getTaskCount()) {
            return false;
        }
        if (this.getCompletedTaskCount() != other.getCompletedTaskCount()) {
            return false;
        }
        if (this.getLargestPoolSize() != other.getLargestPoolSize()) {
            return false;
        }
        if (this.getPoolSize() != other.getPoolSize()) {
            return false;
        }
        if (this.getWaitTaskCount() != other.getWaitTaskCount()) {
            return false;
        }
        if (this.getRejectCount() != other.getRejectCount()) {
            return false;
        }
        String this$dtpName = this.getDtpName();
        String other$dtpName = other.getDtpName();
        if (this$dtpName == null ? other$dtpName != null : !this$dtpName.equals(other$dtpName)) {
            return false;
        }
        String this$queueType = this.getQueueType();
        String other$queueType = other.getQueueType();
        if (this$queueType == null ? other$queueType != null : !this$queueType.equals(other$queueType)) {
            return false;
        }
        String this$rejectHandlerName = this.getRejectHandlerName();
        String other$rejectHandlerName = other.getRejectHandlerName();
        return !(this$rejectHandlerName == null ? other$rejectHandlerName != null : !this$rejectHandlerName.equals(other$rejectHandlerName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ThreadPoolStats;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getCorePoolSize();
        result = result * 59 + this.getMaximumPoolSize();
        result = result * 59 + this.getQueueCapacity();
        result = result * 59 + this.getQueueSize();
        result = result * 59 + (this.isFair() ? 79 : 97);
        result = result * 59 + this.getQueueRemainingCapacity();
        result = result * 59 + this.getActiveCount();
        long $taskCount = this.getTaskCount();
        result = result * 59 + (int)($taskCount >>> 32 ^ $taskCount);
        long $completedTaskCount = this.getCompletedTaskCount();
        result = result * 59 + (int)($completedTaskCount >>> 32 ^ $completedTaskCount);
        result = result * 59 + this.getLargestPoolSize();
        result = result * 59 + this.getPoolSize();
        result = result * 59 + this.getWaitTaskCount();
        result = result * 59 + this.getRejectCount();
        String $dtpName = this.getDtpName();
        result = result * 59 + ($dtpName == null ? 43 : $dtpName.hashCode());
        String $queueType = this.getQueueType();
        result = result * 59 + ($queueType == null ? 43 : $queueType.hashCode());
        String $rejectHandlerName = this.getRejectHandlerName();
        result = result * 59 + ($rejectHandlerName == null ? 43 : $rejectHandlerName.hashCode());
        return result;
    }

    public String getDtpName() {
        return this.dtpName;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public String getQueueType() {
        return this.queueType;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public boolean isFair() {
        return this.fair;
    }

    public int getQueueRemainingCapacity() {
        return this.queueRemainingCapacity;
    }

    public int getActiveCount() {
        return this.activeCount;
    }

    public long getTaskCount() {
        return this.taskCount;
    }

    public long getCompletedTaskCount() {
        return this.completedTaskCount;
    }

    public int getLargestPoolSize() {
        return this.largestPoolSize;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public int getWaitTaskCount() {
        return this.waitTaskCount;
    }

    public int getRejectCount() {
        return this.rejectCount;
    }

    public String getRejectHandlerName() {
        return this.rejectHandlerName;
    }

    public void setDtpName(String dtpName) {
        this.dtpName = dtpName;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public void setQueueType(String queueType) {
        this.queueType = queueType;
    }

    public void setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public void setFair(boolean fair) {
        this.fair = fair;
    }

    public void setQueueRemainingCapacity(int queueRemainingCapacity) {
        this.queueRemainingCapacity = queueRemainingCapacity;
    }

    public void setActiveCount(int activeCount) {
        this.activeCount = activeCount;
    }

    public void setTaskCount(long taskCount) {
        this.taskCount = taskCount;
    }

    public void setCompletedTaskCount(long completedTaskCount) {
        this.completedTaskCount = completedTaskCount;
    }

    public void setLargestPoolSize(int largestPoolSize) {
        this.largestPoolSize = largestPoolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public void setWaitTaskCount(int waitTaskCount) {
        this.waitTaskCount = waitTaskCount;
    }

    public void setRejectCount(int rejectCount) {
        this.rejectCount = rejectCount;
    }

    public void setRejectHandlerName(String rejectHandlerName) {
        this.rejectHandlerName = rejectHandlerName;
    }

    @Override
    public String toString() {
        return "ThreadPoolStats(dtpName=" + this.getDtpName() + ", corePoolSize=" + this.getCorePoolSize() + ", maximumPoolSize=" + this.getMaximumPoolSize() + ", queueType=" + this.getQueueType() + ", queueCapacity=" + this.getQueueCapacity() + ", queueSize=" + this.getQueueSize() + ", fair=" + this.isFair() + ", queueRemainingCapacity=" + this.getQueueRemainingCapacity() + ", activeCount=" + this.getActiveCount() + ", taskCount=" + this.getTaskCount() + ", completedTaskCount=" + this.getCompletedTaskCount() + ", largestPoolSize=" + this.getLargestPoolSize() + ", poolSize=" + this.getPoolSize() + ", waitTaskCount=" + this.getWaitTaskCount() + ", rejectCount=" + this.getRejectCount() + ", rejectHandlerName=" + this.getRejectHandlerName() + ")";
    }

    public static class ThreadPoolStatsBuilder {
        private String dtpName;
        private int corePoolSize;
        private int maximumPoolSize;
        private String queueType;
        private int queueCapacity;
        private int queueSize;
        private boolean fair;
        private int queueRemainingCapacity;
        private int activeCount;
        private long taskCount;
        private long completedTaskCount;
        private int largestPoolSize;
        private int poolSize;
        private int waitTaskCount;
        private int rejectCount;
        private String rejectHandlerName;

        ThreadPoolStatsBuilder() {
        }

        public ThreadPoolStatsBuilder dtpName(String dtpName) {
            this.dtpName = dtpName;
            return this;
        }

        public ThreadPoolStatsBuilder corePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
            return this;
        }

        public ThreadPoolStatsBuilder maximumPoolSize(int maximumPoolSize) {
            this.maximumPoolSize = maximumPoolSize;
            return this;
        }

        public ThreadPoolStatsBuilder queueType(String queueType) {
            this.queueType = queueType;
            return this;
        }

        public ThreadPoolStatsBuilder queueCapacity(int queueCapacity) {
            this.queueCapacity = queueCapacity;
            return this;
        }

        public ThreadPoolStatsBuilder queueSize(int queueSize) {
            this.queueSize = queueSize;
            return this;
        }

        public ThreadPoolStatsBuilder fair(boolean fair) {
            this.fair = fair;
            return this;
        }

        public ThreadPoolStatsBuilder queueRemainingCapacity(int queueRemainingCapacity) {
            this.queueRemainingCapacity = queueRemainingCapacity;
            return this;
        }

        public ThreadPoolStatsBuilder activeCount(int activeCount) {
            this.activeCount = activeCount;
            return this;
        }

        public ThreadPoolStatsBuilder taskCount(long taskCount) {
            this.taskCount = taskCount;
            return this;
        }

        public ThreadPoolStatsBuilder completedTaskCount(long completedTaskCount) {
            this.completedTaskCount = completedTaskCount;
            return this;
        }

        public ThreadPoolStatsBuilder largestPoolSize(int largestPoolSize) {
            this.largestPoolSize = largestPoolSize;
            return this;
        }

        public ThreadPoolStatsBuilder poolSize(int poolSize) {
            this.poolSize = poolSize;
            return this;
        }

        public ThreadPoolStatsBuilder waitTaskCount(int waitTaskCount) {
            this.waitTaskCount = waitTaskCount;
            return this;
        }

        public ThreadPoolStatsBuilder rejectCount(int rejectCount) {
            this.rejectCount = rejectCount;
            return this;
        }

        public ThreadPoolStatsBuilder rejectHandlerName(String rejectHandlerName) {
            this.rejectHandlerName = rejectHandlerName;
            return this;
        }

        public ThreadPoolStats build() {
            return new ThreadPoolStats(this.dtpName, this.corePoolSize, this.maximumPoolSize, this.queueType, this.queueCapacity, this.queueSize, this.fair, this.queueRemainingCapacity, this.activeCount, this.taskCount, this.completedTaskCount, this.largestPoolSize, this.poolSize, this.waitTaskCount, this.rejectCount, this.rejectHandlerName);
        }

        public String toString() {
            return "ThreadPoolStats.ThreadPoolStatsBuilder(dtpName=" + this.dtpName + ", corePoolSize=" + this.corePoolSize + ", maximumPoolSize=" + this.maximumPoolSize + ", queueType=" + this.queueType + ", queueCapacity=" + this.queueCapacity + ", queueSize=" + this.queueSize + ", fair=" + this.fair + ", queueRemainingCapacity=" + this.queueRemainingCapacity + ", activeCount=" + this.activeCount + ", taskCount=" + this.taskCount + ", completedTaskCount=" + this.completedTaskCount + ", largestPoolSize=" + this.largestPoolSize + ", poolSize=" + this.poolSize + ", waitTaskCount=" + this.waitTaskCount + ", rejectCount=" + this.rejectCount + ", rejectHandlerName=" + this.rejectHandlerName + ")";
        }
    }
}

