/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie.mapstruct;

import io.github.linpeilie.AbstractCachedConverterFactory;
import io.github.linpeilie.BaseMapMapper;
import io.github.linpeilie.BaseMapper;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ResolvableType;

public class SpringConverterFactory
extends AbstractCachedConverterFactory {
    private final ApplicationContext applicationContext;

    public SpringConverterFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public <S, T> BaseMapper<S, T> findMapper(Class<S> sourceType, Class<T> targetType) {
        ResolvableType type = ResolvableType.forClassWithGenerics(BaseMapper.class, (Class[])new Class[]{sourceType, targetType});
        String[] beanNames = this.applicationContext.getBeanNamesForType(type);
        if (beanNames.length == 0) {
            return null;
        }
        return (BaseMapper)this.applicationContext.getBean(beanNames[0]);
    }

    protected <S> BaseMapMapper findMapMapper(Class<?> source) {
        ResolvableType type = ResolvableType.forClassWithGenerics(BaseMapMapper.class, (Class[])new Class[]{source});
        String[] beanNames = this.applicationContext.getBeanNamesForType(type);
        if (beanNames.length == 0) {
            return null;
        }
        return (BaseMapMapper)this.applicationContext.getBean(beanNames[0]);
    }
}

