/*
 * Decompiled with CFR 0.152.
 */
package com.gc.easy.flv.util;

import com.alibaba.fastjson.JSONObject;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameGrabber;
import org.bytedeco.javacv.Java2DFrameConverter;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.RestTemplate;

public class FlvUtil {
    private static BufferedImage getBufferedImageByFrame(String filePath) throws IOException {
        FFmpegFrameGrabber grabber = FFmpegFrameGrabber.createDefault((String)filePath);
        return FlvUtil.getBufferedImageByFrame(grabber);
    }

    private static BufferedImage getBufferedImageByFrame(FFmpegFrameGrabber grabber) throws FrameGrabber.Exception {
        grabber.start();
        Frame frame = grabber.grabImage();
        Java2DFrameConverter converter = new Java2DFrameConverter();
        BufferedImage buffer = converter.getBufferedImage(frame);
        grabber.stop();
        return buffer;
    }

    public static byte[] getFlvImg(String path) throws Exception {
        return FlvUtil.bufferedImageToByteArray(FlvUtil.getBufferedImageByFrame(path));
    }

    public static byte[] bufferedImageToByteArray(BufferedImage image) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "jpg", os);
        return os.toByteArray();
    }

    public static JSONObject postFile(byte[] data, String url, final String fileName) {
        RestTemplate restTemplate = new RestTemplate();
        LinkedMultiValueMap paramMap = new LinkedMultiValueMap();
        ByteArrayResource contentsAsResource = new ByteArrayResource(data){

            public String getFilename() {
                return fileName;
            }
        };
        paramMap.add((Object)"file", (Object)contentsAsResource);
        return (JSONObject)restTemplate.postForObject(url, (Object)paramMap, JSONObject.class, new Object[0]);
    }
}

