/*
 * Decompiled with CFR 0.152.
 */
package com.gc.easy.flv.service.impl;

import com.gc.easy.flv.factories.Converter;
import com.gc.easy.flv.factories.ConverterFactories;
import com.gc.easy.flv.service.IFLVService;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FLVService
implements IFLVService {
    private static final Logger log = LoggerFactory.getLogger(FLVService.class);
    private ConcurrentHashMap<String, Converter> converters = new ConcurrentHashMap();

    @Override
    public void open(String url, HttpServletResponse response, HttpServletRequest request) {
        this.open(null, url, response, request);
    }

    @Override
    public void open(Integer channel, String url, HttpServletResponse response, HttpServletRequest request) {
        String key = this.md5(url);
        AsyncContext async = request.startAsync();
        async.setTimeout(0L);
        if (this.converters.containsKey(key)) {
            Converter c = this.converters.get(key);
            try {
                c.addOutputStreamEntity(key, async);
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage());
            }
        } else {
            ArrayList<AsyncContext> outs = new ArrayList<AsyncContext>();
            outs.add(async);
            ConverterFactories c = new ConverterFactories(url, key, this.converters, outs);
            c.start();
            this.converters.put(key, c);
        }
        response.setContentType("video/x-flv");
        response.setHeader("Connection", "keep-alive");
        response.setStatus(200);
        try {
            response.flushBuffer();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public String md5(String plainText) {
        StringBuilder buf = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(plainText.getBytes());
            byte[] b = md.digest();
            buf = new StringBuilder("");
            for (int offset = 0; offset < b.length; ++offset) {
                int i = b[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
            }
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return buf.toString();
    }
}

