/*
 * Decompiled with CFR 0.152.
 */
package com.gc.easy.flv.factories;

import com.alibaba.fastjson.util.IOUtils;
import com.gc.easy.flv.factories.Converter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.AsyncContext;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.FFmpegFrameRecorder;
import org.bytedeco.javacv.Frame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConverterTranFactories
extends Thread
implements Converter {
    private static final Logger log = LoggerFactory.getLogger(ConverterTranFactories.class);
    public volatile boolean runing = true;
    private FFmpegFrameGrabber grabber;
    private FFmpegFrameRecorder recorder;
    private byte[] headers;
    private ByteArrayOutputStream stream;
    private String url;
    private List<AsyncContext> outEntitys;
    private String key;
    private Map<String, Converter> factories;

    public ConverterTranFactories(String url, String key, Map<String, Converter> factories, List<AsyncContext> outEntitys, FFmpegFrameGrabber grabber) {
        this.url = url;
        this.key = key;
        this.factories = factories;
        this.outEntitys = outEntitys;
        this.grabber = grabber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            log.info("this url:{} converterTranFactories start", (Object)this.url);
            this.grabber.setFrameRate(25.0);
            if (this.grabber.getImageWidth() > 1920) {
                this.grabber.setImageWidth(1920);
            }
            if (this.grabber.getImageHeight() > 1080) {
                this.grabber.setImageHeight(1080);
            }
            this.stream = new ByteArrayOutputStream();
            this.recorder = new FFmpegFrameRecorder((OutputStream)this.stream, this.grabber.getImageWidth(), this.grabber.getImageHeight(), this.grabber.getAudioChannels());
            this.recorder.setInterleaved(true);
            this.recorder.setVideoOption("preset", "ultrafast");
            this.recorder.setVideoOption("tune", "zerolatency");
            this.recorder.setVideoOption("crf", "25");
            this.recorder.setGopSize(50);
            this.recorder.setFrameRate(25.0);
            this.recorder.setSampleRate(this.grabber.getSampleRate());
            if (this.grabber.getAudioChannels() > 0) {
                this.recorder.setAudioChannels(this.grabber.getAudioChannels());
                this.recorder.setAudioBitrate(this.grabber.getAudioBitrate());
                this.recorder.setAudioCodec(86018);
            }
            this.recorder.setFormat("flv");
            this.recorder.setVideoBitrate(this.grabber.getVideoBitrate());
            this.recorder.setVideoCodec(27);
            this.recorder.start();
            if (this.headers == null) {
                this.headers = this.stream.toByteArray();
                this.stream.reset();
                this.writeResponse(this.headers);
            }
            int nullNumber = 0;
            while (this.runing) {
                Frame f = this.grabber.grab();
                if (f != null) {
                    try {
                        this.recorder.record(f);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.stream.size() > 0) {
                        byte[] b = this.stream.toByteArray();
                        this.stream.reset();
                        this.writeResponse(b);
                        if (this.outEntitys.isEmpty()) {
                            log.info("\u6ca1\u6709\u8f93\u51fa\u9000\u51fa");
                            break;
                        }
                    }
                } else if (++nullNumber > 200) {
                    break;
                }
                Thread.sleep(5L);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeConverter();
            this.completeResponse();
            log.info("this url:{} converterTranFactories exit", (Object)this.url);
            this.factories.remove(this.key);
        }
    }

    public void writeResponse(byte[] b) {
        Iterator<AsyncContext> it = this.outEntitys.iterator();
        while (it.hasNext()) {
            AsyncContext o = it.next();
            try {
                o.getResponse().getOutputStream().write(b);
            }
            catch (Exception e) {
                log.info("\u79fb\u9664\u4e00\u4e2a\u8f93\u51fa");
                it.remove();
            }
        }
    }

    public void closeConverter() {
        IOUtils.close((Closeable)this.grabber);
        IOUtils.close((Closeable)this.recorder);
        IOUtils.close((Closeable)this.stream);
    }

    public void completeResponse() {
        for (AsyncContext o : this.outEntitys) {
            o.complete();
        }
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void addOutputStreamEntity(String key, AsyncContext entity) throws IOException {
        if (this.headers == null) {
            this.outEntitys.add(entity);
        } else {
            entity.getResponse().getOutputStream().write(this.headers);
            entity.getResponse().getOutputStream().flush();
            this.outEntitys.add(entity);
        }
    }

    @Override
    public void exit() {
        this.runing = false;
        try {
            this.join();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

