/*
 * Decompiled with CFR 0.152.
 */
package com.gc.easy.flv.factories;

import com.alibaba.fastjson.util.IOUtils;
import com.gc.easy.flv.factories.Converter;
import com.gc.easy.flv.factories.ConverterTranFactories;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.AsyncContext;
import org.bytedeco.ffmpeg.avcodec.AVPacket;
import org.bytedeco.ffmpeg.global.avcodec;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.FFmpegFrameRecorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConverterFactories
extends Thread
implements Converter {
    private static final Logger log = LoggerFactory.getLogger(ConverterFactories.class);
    public volatile boolean runing = true;
    private FFmpegFrameGrabber grabber;
    private FFmpegFrameRecorder recorder;
    private byte[] headers;
    private ByteArrayOutputStream stream;
    private String url;
    private List<AsyncContext> outEntitys;
    private String key;
    private Map<String, Converter> factories;

    public ConverterFactories(String url, String key, Map<String, Converter> factories, List<AsyncContext> outEntitys) {
        this.url = url;
        this.key = key;
        this.factories = factories;
        this.outEntitys = outEntitys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block17: {
            boolean isCloseGrabberAndResponse = true;
            try {
                this.grabber = new FFmpegFrameGrabber(this.url);
                if ("rtsp".equals(this.url.substring(0, 4))) {
                    this.grabber.setOption("rtsp_transport", "tcp");
                    this.grabber.setOption("stimeout", "5000000");
                }
                this.grabber.start();
                if (27 == this.grabber.getVideoCodec() && (this.grabber.getAudioChannels() == 0 || 86018 == this.grabber.getAudioCodec())) {
                    log.info("this url:{} converterFactories start", (Object)this.url);
                    this.stream = new ByteArrayOutputStream();
                    this.recorder = new FFmpegFrameRecorder((OutputStream)this.stream, this.grabber.getImageWidth(), this.grabber.getImageHeight(), this.grabber.getAudioChannels());
                    this.recorder.setInterleaved(true);
                    this.recorder.setVideoOption("preset", "ultrafast");
                    this.recorder.setVideoOption("tune", "zerolatency");
                    this.recorder.setVideoOption("crf", "25");
                    this.recorder.setFrameRate(this.grabber.getFrameRate());
                    this.recorder.setSampleRate(this.grabber.getSampleRate());
                    if (this.grabber.getAudioChannels() > 0) {
                        this.recorder.setAudioChannels(this.grabber.getAudioChannels());
                        this.recorder.setAudioBitrate(this.grabber.getAudioBitrate());
                        this.recorder.setAudioCodec(this.grabber.getAudioCodec());
                    }
                    this.recorder.setFormat("flv");
                    this.recorder.setVideoBitrate(this.grabber.getVideoBitrate());
                    this.recorder.setVideoCodec(this.grabber.getVideoCodec());
                    this.recorder.start(this.grabber.getFormatContext());
                    if (this.headers == null) {
                        this.headers = this.stream.toByteArray();
                        this.stream.reset();
                        this.writeResponse(this.headers);
                    }
                    int nullNumber = 0;
                    while (this.runing) {
                        AVPacket k = this.grabber.grabPacket();
                        if (k != null) {
                            try {
                                this.recorder.recordPacket(k);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (this.stream.size() > 0) {
                                byte[] b = this.stream.toByteArray();
                                this.stream.reset();
                                this.writeResponse(b);
                                if (this.outEntitys.isEmpty()) {
                                    log.info("\u6ca1\u6709\u8f93\u51fa\u9000\u51fa");
                                    break block17;
                                }
                            }
                            avcodec.av_packet_unref((AVPacket)k);
                        } else if (++nullNumber > 200) {
                            break block17;
                        }
                        Thread.sleep(5L);
                    }
                    break block17;
                }
                isCloseGrabberAndResponse = false;
                ConverterTranFactories c = new ConverterTranFactories(this.url, this.key, this.factories, this.outEntitys, this.grabber);
                this.factories.put(this.key, c);
                c.start();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                this.closeConverter(isCloseGrabberAndResponse);
                this.completeResponse(isCloseGrabberAndResponse);
                log.info("this url:{} converterFactories exit", (Object)this.url);
            }
        }
    }

    public void writeResponse(byte[] b) {
        Iterator<AsyncContext> it = this.outEntitys.iterator();
        while (it.hasNext()) {
            AsyncContext o = it.next();
            try {
                o.getResponse().getOutputStream().write(b);
            }
            catch (Exception e) {
                log.info("\u79fb\u9664\u4e00\u4e2a\u8f93\u51fa");
                it.remove();
            }
        }
    }

    public void closeConverter(boolean isCloseGrabberAndResponse) {
        if (isCloseGrabberAndResponse) {
            IOUtils.close((Closeable)this.grabber);
            this.factories.remove(this.key);
        }
        IOUtils.close((Closeable)this.recorder);
        IOUtils.close((Closeable)this.stream);
    }

    public void completeResponse(boolean isCloseGrabberAndResponse) {
        if (isCloseGrabberAndResponse) {
            for (AsyncContext o : this.outEntitys) {
                o.complete();
            }
        }
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void addOutputStreamEntity(String key, AsyncContext entity) throws IOException {
        if (this.headers == null) {
            this.outEntitys.add(entity);
        } else {
            entity.getResponse().getOutputStream().write(this.headers);
            entity.getResponse().getOutputStream().flush();
            this.outEntitys.add(entity);
        }
    }

    @Override
    public void exit() {
        this.runing = false;
        try {
            this.join();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

