/*
 * Decompiled with CFR 0.152.
 */
package io.github.saluki.plugin.maven;

import com.google.common.collect.Lists;
import io.github.saluki.plugin.common.CommonProto2Java;
import java.io.File;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="proto2java", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class Proto2Java
extends AbstractMojo {
    @Parameter(defaultValue="src/main/proto")
    private String protoPath;
    @Parameter(defaultValue="src/main/java")
    private String buildPath;
    private List<File> allProtoFile = Lists.newArrayList();

    public void execute() throws MojoExecutionException, MojoFailureException {
        File deirectory = new File(this.protoPath);
        this.listAllProtoFile(deirectory);
        CommonProto2Java protp2ServicePojo = CommonProto2Java.forConfig((String)this.protoPath, (String)this.buildPath);
        for (File file : this.allProtoFile) {
            if (!file.exists()) continue;
            String protoFilePath = file.getPath();
            protp2ServicePojo.generateFile(protoFilePath);
        }
    }

    private File listAllProtoFile(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                if (fileArray != null) {
                    for (int i = 0; i < fileArray.length; ++i) {
                        this.listAllProtoFile(fileArray[i]);
                    }
                }
            } else if (StringUtils.endsWith((CharSequence)file.getName(), (CharSequence)"proto")) {
                this.allProtoFile.add(file);
            }
        }
        return null;
    }
}

