/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.html.util;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.xwpf.usermodel.XWPFAbstractNum;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFNumbering;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTAbstractNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTInd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTLvl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMultiLevelType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STNumberFormat;

public class NumberingContext {
    private static final int INDENT = 360;
    public static final String BULLET_CHAR = "\u26ab";
    private final XWPFDocument document;
    private int nextAbstractNumberId;
    private int nextNumberingLevel;
    private List<STNumberFormat.Enum> numberFormats;
    private Map<String, BigInteger> numberIdMap = new HashMap<String, BigInteger>(4);
    private List<XWPFParagraph> numberingParagraphs;

    public NumberingContext(XWPFDocument document) {
        this.document = document;
    }

    public void startLevel(STNumberFormat.Enum format) {
        int level;
        if ((level = this.nextNumberingLevel++) == 0) {
            this.numberingParagraphs = new ArrayList<XWPFParagraph>(8);
            this.numberFormats = new ArrayList<STNumberFormat.Enum>(4);
        }
        this.numberFormats.add(format);
    }

    public void endLevel() {
        --this.nextNumberingLevel;
        if (this.nextNumberingLevel == 0) {
            String key = this.getFormatKey();
            BigInteger numberId = this.getNumberId(key);
            for (XWPFParagraph paragraph : this.numberingParagraphs) {
                paragraph.setNumID(numberId);
            }
            this.numberingParagraphs = null;
            this.numberFormats = null;
        }
    }

    public void add(XWPFParagraph paragraph) {
        if (this.numberingParagraphs == null) {
            throw new IllegalStateException("Call startLevel method first");
        }
        paragraph.setNumILvl(BigInteger.valueOf(this.nextNumberingLevel - 1));
        this.numberingParagraphs.add(paragraph);
    }

    private BigInteger getNumberId(String key) {
        BigInteger numberId;
        block3: {
            BigInteger abstractNumberId;
            XWPFAbstractNum abstractNum;
            numberId = null;
            for (Map.Entry<String, BigInteger> entry : this.numberIdMap.entrySet()) {
                if (!entry.getKey().startsWith(key)) continue;
                numberId = entry.getValue();
                break;
            }
            if (numberId != null) break block3;
            XWPFNumbering numbering = this.document.createNumbering();
            while ((abstractNum = numbering.getAbstractNum(abstractNumberId = BigInteger.valueOf(this.nextAbstractNumberId++))) != null) {
            }
            CTAbstractNum ctAbstractNum = CTAbstractNum.Factory.newInstance();
            ctAbstractNum.setAbstractNumId(abstractNumberId);
            ctAbstractNum.addNewMultiLevelType().setVal(STMultiLevelType.HYBRID_MULTILEVEL);
            for (int i = 0; i < this.numberFormats.size(); ++i) {
                STNumberFormat.Enum format = this.numberFormats.get(i);
                CTLvl cTLvl = ctAbstractNum.addNewLvl();
                CTInd ind = cTLvl.addNewPPr().addNewInd();
                ind.setLeft(BigInteger.valueOf(360 * i));
                cTLvl.addNewNumFmt().setVal(format);
                cTLvl.addNewLvlText().setVal(format == STNumberFormat.BULLET ? BULLET_CHAR : this.getOrderedLevelText(i));
                cTLvl.addNewStart().setVal(BigInteger.ONE);
                cTLvl.setIlvl(BigInteger.valueOf(i));
                cTLvl.addNewLvlJc().setVal(STJc.LEFT);
            }
            numbering.addAbstractNum(new XWPFAbstractNum(ctAbstractNum, numbering));
            numberId = numbering.addNum(abstractNumberId);
            this.numberIdMap.put(key, numberId);
        }
        return numberId;
    }

    private String getOrderedLevelText(int i) {
        return "%" + (i + 1) + ".";
    }

    private String getFormatKey() {
        StringBuilder sb = new StringBuilder();
        for (STNumberFormat.Enum format : this.numberFormats) {
            sb.append(format.intValue()).append(" ");
        }
        return sb.toString();
    }
}

