/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.html.tag;

import com.steadystate.css.dom.CSSStyleDeclarationImpl;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.ddr.poi.html.ElementRenderer;
import org.ddr.poi.html.HtmlRenderContext;
import org.ddr.poi.html.util.CSSLength;
import org.ddr.poi.html.util.CSSLengthUnit;
import org.ddr.poi.html.util.JsoupUtils;
import org.ddr.poi.html.util.RenderUtils;
import org.ddr.poi.html.util.Span;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblGrid;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblGridCol;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblWidth;

public class TableRenderer
implements ElementRenderer {
    private static final String[] TAGS = new String[]{"table"};

    @Override
    public boolean renderStart(Element element, HtmlRenderContext context) {
        CSSStyleDeclarationImpl styleDeclaration = context.currentElementStyle();
        String widthDeclaration = styleDeclaration.getWidth();
        XWPFTable table = context.getClosestTable();
        int containerWidth = context.getAvailableWidthInEMU();
        CSSLength width = CSSLength.of(widthDeclaration);
        boolean explicitWidth = width.isValid() && !width.isPercent();
        int tableWidth = context.computeLengthInEMU(widthDeclaration, styleDeclaration.getMaxWidth(), containerWidth, containerWidth);
        int originWidth = !width.isValid() || width.isPercent() ? tableWidth : context.lengthToEMU(width);
        Element colgroup = JsoupUtils.firstChild(element, "colgroup");
        if (colgroup != null) {
            Elements cols = colgroup.select("col");
            colgroup.remove();
        }
        Elements trs = JsoupUtils.childRows(element);
        HashMap<Integer, Span> rowSpanMap = new HashMap<Integer, Span>(4);
        TreeMap<Integer, CSSLength> colWidthMap = new TreeMap<Integer, CSSLength>();
        for (int r = 0; r < trs.size(); ++r) {
            Element tr = (Element)trs.get(r);
            XWPFTableRow row = this.createRow(table, r);
            Elements tds = JsoupUtils.children(tr, "th", "td");
            int columnSum = 0;
            int minRowSpan = 1;
            for (int c = 0; c < tds.size(); ++c) {
                Element td = (Element)tds.get(c);
                CSSStyleDeclarationImpl tdStyleDeclaration = RenderUtils.parse(td.attr("style"));
                CSSLength cSSLength = CSSLength.of(tdStyleDeclaration.getWidth());
                int rowspan = NumberUtils.toInt((String)td.attr("rowspan"), (int)1);
                int colspan = NumberUtils.toInt((String)td.attr("colspan"), (int)1);
                minRowSpan = Math.min(minRowSpan, rowspan);
                for (Map.Entry entry : rowSpanMap.entrySet()) {
                    if ((Integer)entry.getKey() > columnSum || !((Span)entry.getValue()).isEnabled()) continue;
                    columnSum += ((Span)entry.getValue()).getColumn();
                    ((Span)entry.getValue()).setEnabled(false);
                    XWPFTableCell cell = this.createCell(row, c);
                    CTTcPr ctTcPr = RenderUtils.getTcPr(cell.getCTTc());
                    ctTcPr.addNewVMerge();
                    if (((Span)entry.getValue()).getColumn() <= 1) continue;
                    ctTcPr.addNewGridSpan().setVal(BigInteger.valueOf(((Span)entry.getValue()).getColumn()));
                }
                td.attr("_r", String.valueOf(r));
                td.attr("_c", String.valueOf(c));
                XWPFTableCell cell = this.createCell(row, c);
                CTTcPr ctTcPr = RenderUtils.getTcPr(cell.getCTTc());
                if (rowspan > 1) {
                    rowSpanMap.put(columnSum, new Span(rowspan, colspan, false));
                    CTVMerge ctvMerge = ctTcPr.isSetVMerge() ? ctTcPr.getVMerge() : ctTcPr.addNewVMerge();
                    ctvMerge.setVal(STMerge.RESTART);
                }
                if (colspan == 1) {
                    CSSLength existingWidth = (CSSLength)colWidthMap.get(columnSum);
                    if (existingWidth == null || !existingWidth.isValid()) {
                        colWidthMap.put(columnSum, cSSLength);
                    } else if (explicitWidth) {
                        if (existingWidth.isPercent()) {
                            colWidthMap.put(columnSum, cSSLength);
                        }
                    } else if (!existingWidth.isPercent()) {
                        colWidthMap.put(columnSum, cSSLength);
                    }
                } else {
                    ctTcPr.addNewGridSpan().setVal(BigInteger.valueOf(colspan));
                }
                columnSum += colspan;
            }
            Iterator iterator = rowSpanMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                ((Span)entry.getValue()).setRow(((Span)entry.getValue()).getRow() - minRowSpan);
                if (((Span)entry.getValue()).getRow() == 0) {
                    iterator.remove();
                    continue;
                }
                ((Span)entry.getValue()).setEnabled(true);
            }
        }
        CTTbl ctTbl = table.getCTTbl();
        CTTblGrid tblGrid = ctTbl.getTblGrid();
        if (tblGrid == null) {
            tblGrid = ctTbl.addNewTblGrid();
        }
        BigInteger[] colWidths = new BigInteger[colWidthMap.size()];
        double unhandledPercentSum = 0.0;
        int unhandledEmuSum = 0;
        int unhandledEmuCount = 0;
        int remainWidth = tableWidth;
        BigInteger[] iterator = colWidthMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            CSSLength value = (CSSLength)entry.getValue();
            if (!value.isValid()) {
                entry.setValue(new CSSLength(100.0 / (double)colWidths.length, CSSLengthUnit.PERCENT));
                unhandledPercentSum += ((CSSLength)entry.getValue()).getValue();
                continue;
            }
            if (explicitWidth) {
                if (value.isPercent()) {
                    unhandledPercentSum += value.getValue();
                    continue;
                }
                int emu = (int)((long)value.toEMU() * (long)tableWidth / (long)originWidth);
                colWidths[((Integer)entry.getKey()).intValue()] = BigInteger.valueOf(RenderUtils.emuToTwips(emu));
                remainWidth -= emu;
                iterator.remove();
                continue;
            }
            if (value.isPercent()) {
                unhandledPercentSum += value.getValue();
                continue;
            }
            unhandledPercentSum += 100.0 / (double)colWidths.length;
            unhandledEmuSum += value.toEMU();
            ++unhandledEmuCount;
        }
        for (Map.Entry entry : colWidthMap.entrySet()) {
            CSSLength value = (CSSLength)entry.getValue();
            if (value.isPercent()) {
                colWidths[((Integer)entry.getKey()).intValue()] = BigInteger.valueOf((int)Math.rint((double)remainWidth * value.getValue() / unhandledPercentSum * 20.0 / 12700.0));
                continue;
            }
            colWidths[((Integer)entry.getKey()).intValue()] = BigInteger.valueOf((int)Math.rint((double)remainWidth * ((double)unhandledEmuCount * 100.0 / (double)colWidths.length / unhandledPercentSum) * (double)value.toEMU() / (double)unhandledEmuSum * 20.0 / 12700.0));
        }
        for (BigInteger colWidth : colWidths) {
            CTTblGridCol ctTblGridCol = tblGrid.addNewGridCol();
            ctTblGridCol.setW(colWidth);
        }
        int n = ctTbl.sizeOfTrArray();
        for (int i = 0; i < n; ++i) {
            CTRow ctRow = ctTbl.getTrArray(i);
            int cells = ctRow.sizeOfTcArray();
            for (int j = 0; j < cells; ++j) {
                CTTc ctTc = ctRow.getTcArray(j);
                CTTcPr tcPr = RenderUtils.getTcPr(ctTc);
                int colspan = tcPr.isSetGridSpan() ? tcPr.getGridSpan().getVal().intValue() : 1;
                CTTblWidth tcWidth = tcPr.addNewTcW();
                tcWidth.setType(STTblWidth.DXA);
                if (colspan == 1) {
                    tcWidth.setW(colWidths[j]);
                    continue;
                }
                int sum = 0;
                for (int k = 0; k < colspan; ++k) {
                    sum += colWidths[j + k].intValue();
                }
                tcWidth.setW(BigInteger.valueOf(sum));
            }
        }
        return true;
    }

    private XWPFTableCell createCell(XWPFTableRow row, int c) {
        return row.createCell();
    }

    private XWPFTableRow createRow(XWPFTable table, int r) {
        return table.insertNewTableRow(r);
    }

    @Override
    public String[] supportedTags() {
        return TAGS;
    }

    @Override
    public boolean renderAsBlock() {
        return true;
    }
}

