/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.html.tag;

import org.ddr.poi.html.ElementRenderer;
import org.ddr.poi.html.HtmlRenderContext;
import org.jsoup.nodes.Element;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STNumberFormat;

public class ListRenderer
implements ElementRenderer {
    private static final String[] TAGS = new String[]{"ul", "ol"};

    @Override
    public boolean renderStart(Element element, HtmlRenderContext context) {
        context.getNumberingContext().startLevel(this.determineNumberFormat(element));
        return true;
    }

    private STNumberFormat.Enum determineNumberFormat(Element element) {
        STNumberFormat.Enum format;
        switch (element.tag().normalName()) {
            case "ol": {
                format = STNumberFormat.DECIMAL;
                break;
            }
            case "ul": {
                format = STNumberFormat.BULLET;
                break;
            }
            default: {
                format = STNumberFormat.NONE;
            }
        }
        return format;
    }

    @Override
    public void renderEnd(Element element, HtmlRenderContext context) {
        context.getNumberingContext().endLevel();
    }

    @Override
    public String[] supportedTags() {
        return TAGS;
    }

    @Override
    public boolean renderAsBlock() {
        return false;
    }
}

