/*
 * Decompiled with CFR 0.152.
 */
package org.ddr.poi.html.tag;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.util.Units;
import org.ddr.poi.html.ElementRenderer;
import org.ddr.poi.html.HtmlRenderContext;
import org.ddr.poi.util.ByteArrayCopyStream;
import org.ddr.poi.util.HttpURLConnectionUtils;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageRenderer
implements ElementRenderer {
    private static final Logger log = LoggerFactory.getLogger(ImageRenderer.class);
    private static final String[] TAGS = new String[]{"img"};
    private static final String HTTP = "http";
    private static final String DOUBLE_SLASH = "//";
    private static final String BASE64_PREFIX = "data:";
    private static final Map<String, Integer> PICTURE_TYPES = new HashMap<String, Integer>(12);

    @Override
    public boolean renderStart(Element element, HtmlRenderContext context) {
        String src = element.attr("src");
        if (StringUtils.startsWithIgnoreCase((CharSequence)src, (CharSequence)HTTP)) {
            this.handleRemoteImage(element, context, src);
        } else if (StringUtils.startsWith((CharSequence)src, (CharSequence)DOUBLE_SLASH)) {
            this.handleRemoteImage(element, context, "http:" + src);
        } else if (StringUtils.startsWith((CharSequence)src, (CharSequence)BASE64_PREFIX)) {
            this.handleBase64(element, context, src);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBase64(Element element, HtmlRenderContext context, String src) {
        byte[] bytes;
        int index = src.indexOf(",".charAt(0));
        String data = src.substring(index + 1);
        String format = StringUtils.substringBetween((String)src.substring(0, index), (String)"/", (String)";");
        if (format.contains("-")) {
            format = StringUtils.substringAfterLast((String)format, (String)"-");
        } else if (format.contains("+")) {
            format = StringUtils.substringBefore((String)format, (String)"+");
        }
        try {
            bytes = Base64.getDecoder().decode(data);
        }
        catch (Exception e) {
            log.warn("Failed to load image due to illegal base64 data: {}", (Object)src);
            return;
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            BufferedImage image = ImageIO.read(inputStream);
            ((InputStream)inputStream).reset();
            Integer type = PICTURE_TYPES.getOrDefault(format, image.getColorModel().hasAlpha() ? 6 : 5);
            this.addPicture(element, context, inputStream, type, image.getWidth(), image.getHeight());
        }
        catch (IOException | InvalidFormatException e) {
            log.warn("Failed to load image: {}", (Object)src, (Object)e);
        }
        finally {
            Object image = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRemoteImage(Element element, HtmlRenderContext context, String src) {
        block10: {
            BufferedImage image;
            String extension = FilenameUtils.getExtension((String)StringUtils.substringBefore((String)src, (String)"?")).toLowerCase();
            Integer type = PICTURE_TYPES.get(extension);
            ByteArrayCopyStream outputStream = null;
            InputStream inputStream = null;
            HttpURLConnection connect = null;
            try {
                connect = HttpURLConnectionUtils.connect(src);
                image = ImageIO.read(connect.getInputStream());
                if (image == null) {
                    log.warn("Illegal image url: {}", (Object)src);
                    return;
                }
                int size = image.getData().getDataBuffer().getSize();
                outputStream = new ByteArrayCopyStream(size);
                if (type == null) {
                    if (image.getColorModel().hasAlpha()) {
                        extension = "png";
                        type = 6;
                    } else {
                        extension = "jpeg";
                        type = 5;
                    }
                }
                ImageIO.write((RenderedImage)image, extension, outputStream);
                inputStream = outputStream.toInput();
                this.addPicture(element, context, inputStream, type, image.getWidth(), image.getHeight());
                IOUtils.close((URLConnection)connect);
            }
            catch (IOException | InvalidFormatException e) {
                log.warn("Failed to load image: {}", (Object)src, (Object)e);
                break block10;
            }
            finally {
                IOUtils.close((URLConnection)connect);
                IOUtils.closeQuietly(outputStream);
                IOUtils.closeQuietly(inputStream);
                image = null;
            }
            IOUtils.closeQuietly((OutputStream)outputStream);
            IOUtils.closeQuietly((InputStream)inputStream);
            image = null;
        }
    }

    @Override
    public String[] supportedTags() {
        return TAGS;
    }

    @Override
    public boolean renderAsBlock() {
        return false;
    }

    private void addPicture(Element element, HtmlRenderContext context, InputStream inputStream, int type, int widthInPixels, int heightInPixels) throws InvalidFormatException, IOException {
        int containerWidth = context.getAvailableWidthInEMU();
        int widthInEMU = Units.pixelToEMU((int)widthInPixels);
        int heightInEMU = Units.pixelToEMU((int)heightInPixels);
        boolean declaredWidth = false;
        boolean declaredHeight = false;
        String width = context.getPropertyValue("width");
        if (width.length() > 0) {
            declaredWidth = true;
        } else {
            width = element.attr("width");
            if (NumberUtils.isParsable((String)width)) {
                width = width + "px";
                declaredWidth = true;
            }
        }
        String maxWidth = context.getPropertyValue("max-width");
        widthInEMU = context.computeLengthInEMU(width, maxWidth, widthInEMU, containerWidth);
        String height = context.getPropertyValue("height");
        if (height.length() > 0) {
            declaredHeight = true;
        } else {
            height = element.attr("height");
            if (NumberUtils.isParsable((String)height)) {
                height = height + "px";
                declaredHeight = true;
            }
        }
        String maxHeight = context.getPropertyValue("max-height");
        heightInEMU = context.computeLengthInEMU(height, maxHeight, heightInEMU, Integer.MAX_VALUE);
        if (declaredWidth && !declaredHeight) {
            heightInEMU = heightInPixels * widthInEMU / widthInPixels;
        } else if (!declaredWidth && declaredHeight && (widthInEMU = widthInPixels * heightInEMU / heightInPixels) > containerWidth) {
            widthInEMU = containerWidth;
            heightInEMU = heightInPixels * widthInEMU / widthInPixels;
        }
        context.renderPicture(inputStream, type, "img", widthInEMU, heightInEMU);
    }

    static {
        PICTURE_TYPES.put("emf", 2);
        PICTURE_TYPES.put("wmf", 3);
        PICTURE_TYPES.put("pict", 4);
        PICTURE_TYPES.put("jpeg", 5);
        PICTURE_TYPES.put("jpg", 5);
        PICTURE_TYPES.put("png", 6);
        PICTURE_TYPES.put("dib", 7);
        PICTURE_TYPES.put("gif", 8);
        PICTURE_TYPES.put("tiff", 9);
        PICTURE_TYPES.put("eps", 10);
        PICTURE_TYPES.put("bmp", 11);
        PICTURE_TYPES.put("wpg", 12);
    }
}

