/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.asgard.schedule;

import com.fasterxml.jackson.core.type.TypeReference;
import io.choerodon.asgard.common.AbstractAsgardConsumer;
import io.choerodon.asgard.common.ApplicationContextHelper;
import io.choerodon.asgard.common.InstanceResultUtils;
import io.choerodon.asgard.common.UpdateStatusDTO;
import io.choerodon.asgard.schedule.JobTaskInvokeBean;
import io.choerodon.asgard.schedule.QuartzDefinition;
import io.choerodon.asgard.schedule.annotation.JobTask;
import io.choerodon.asgard.schedule.dto.PollScheduleInstanceDTO;
import io.choerodon.asgard.schedule.dto.ScheduleInstanceConsumerDTO;
import io.choerodon.asgard.schedule.feign.ScheduleConsumerClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.util.StringUtils;

public class ScheduleConsumer
extends AbstractAsgardConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduleConsumer.class);
    private static final Map<String, JobTaskInvokeBean> invokeBeanMap = new HashMap<String, JobTaskInvokeBean>();
    private ScheduleConsumerClient scheduleConsumerClient;
    private PollScheduleInstanceDTO pollScheduleInstanceDTO;

    public ScheduleConsumer(String service, String instance, PlatformTransactionManager transactionManager, Executor executor, ScheduledExecutorService schedule, ApplicationContextHelper contextHelper, long pollIntervalMs) {
        super(service, instance, transactionManager, executor, schedule, contextHelper, pollIntervalMs);
    }

    public void setScheduleConsumerClient(ScheduleConsumerClient scheduleConsumerClient) {
        this.scheduleConsumerClient = scheduleConsumerClient;
    }

    private PollScheduleInstanceDTO getPollScheduleInstanceDTO() {
        if (this.pollScheduleInstanceDTO == null) {
            Set<String> pollMethods = invokeBeanMap.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toSet());
            this.pollScheduleInstanceDTO = new PollScheduleInstanceDTO(pollMethods, this.instance, this.service, this.runningTasks);
        }
        return this.pollScheduleInstanceDTO;
    }

    @Override
    protected void scheduleRunning(String instance) {
        this.scheduleConsumerClient.pollBatch(this.getPollScheduleInstanceDTO()).forEach(t -> {
            LOGGER.trace("ScheduleConsumer polled scheduleTaskInstances: {}", t);
            this.runningTasks.add(t.getId());
            CompletableFuture.supplyAsync(() -> this.invoke((ScheduleInstanceConsumerDTO)t), this.executor).exceptionally(ex -> {
                LOGGER.warn("@JobTask method: {}, id: {} supplyAsync failed", new Object[]{t.getMethod(), t.getId(), ex});
                return null;
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScheduleInstanceConsumerDTO invoke(ScheduleInstanceConsumerDTO data) {
        JobTaskInvokeBean invokeBean = invokeBeanMap.get(data.getMethod());
        JobTask jobTask = invokeBean.jobTask;
        PlatformTransactionManager platformTransactionManager = this.getSagaTaskTransactionManager(jobTask.transactionManager());
        TransactionStatus status = this.createTransactionStatus(this.transactionManager, jobTask.transactionIsolation().value());
        this.beforeInvoke(data.getUserDetails());
        try {
            invokeBean.method.setAccessible(true);
            Object result = invokeBean.method.invoke(invokeBean.object, this.getInputMap(data.getExecuteParams()));
            if (result != null) {
                result = this.objectMapper.writeValueAsString(result);
            }
            this.scheduleConsumerClient.updateStatus(data.getId(), new UpdateStatusDTO(data.getId(), QuartzDefinition.InstanceStatus.COMPLETED.name(), InstanceResultUtils.resultToJson(result, this.objectMapper), null, data.getObjectVersionNumber()));
            platformTransactionManager.commit(status);
            this.runningTasks.remove(data.getId());
        }
        catch (Exception e) {
            String errorMsg = InstanceResultUtils.getErrorInfoFromException(e);
            LOGGER.info("@JobTask method: {}, id: {} invoke error", new Object[]{data.getMethod(), data.getId(), InstanceResultUtils.getLoggerException(e)});
            this.invokeError(platformTransactionManager, status, data, errorMsg);
        }
        finally {
            this.afterInvoke();
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void invokeError(PlatformTransactionManager platformTransactionManager, TransactionStatus status, ScheduleInstanceConsumerDTO data, String errorMsg) {
        block10: {
            platformTransactionManager.rollback(status);
            try {
                this.scheduleConsumerClient.updateStatus(data.getId(), new UpdateStatusDTO(data.getId(), QuartzDefinition.InstanceStatus.FAILED.name(), null, errorMsg, data.getObjectVersionNumber()));
                this.runningTasks.remove(data.getId());
            }
            catch (Exception ex) {
                LOGGER.warn("@JobTask method: {}, id: {} updateStatusFailed error, error message: {}", new Object[]{data.getMethod(), data.getId(), ex.getMessage()});
                this.runningTasks.remove(data.getId());
            }
            break block10;
            catch (Exception e) {
                try {
                    LOGGER.warn("@JobTask method: {}, id: {} transaction rollback error", new Object[]{data.getMethod(), data.getId(), e});
                }
                catch (Throwable throwable) {
                    try {
                        this.scheduleConsumerClient.updateStatus(data.getId(), new UpdateStatusDTO(data.getId(), QuartzDefinition.InstanceStatus.FAILED.name(), null, errorMsg, data.getObjectVersionNumber()));
                        this.runningTasks.remove(data.getId());
                    }
                    catch (Exception ex) {
                        LOGGER.warn("@JobTask method: {}, id: {} updateStatusFailed error, error message: {}", new Object[]{data.getMethod(), data.getId(), ex.getMessage()});
                        this.runningTasks.remove(data.getId());
                    }
                    throw throwable;
                }
                try {
                    this.scheduleConsumerClient.updateStatus(data.getId(), new UpdateStatusDTO(data.getId(), QuartzDefinition.InstanceStatus.FAILED.name(), null, errorMsg, data.getObjectVersionNumber()));
                    this.runningTasks.remove(data.getId());
                }
                catch (Exception ex) {
                    LOGGER.warn("@JobTask method: {}, id: {} updateStatusFailed error, error message: {}", new Object[]{data.getMethod(), data.getId(), ex.getMessage()});
                    this.runningTasks.remove(data.getId());
                }
            }
        }
    }

    private Map<String, Object> getInputMap(String jsonMap) throws IOException {
        if (StringUtils.isEmpty((Object)jsonMap)) {
            return new HashMap<String, Object>();
        }
        return (Map)this.objectMapper.readValue(jsonMap, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    static void addInvokeBean(String key, JobTaskInvokeBean invokeBean) {
        invokeBeanMap.put(key, invokeBean);
    }
}

