/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.asgard.schedule;

import io.choerodon.asgard.schedule.JobTaskInvokeBean;
import io.choerodon.asgard.schedule.ScheduleConsumer;
import io.choerodon.asgard.schedule.annotation.JobTask;
import io.choerodon.asgard.schedule.exception.InvalidJobTaskMethodException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class JobTaskProcessor
implements BeanPostProcessor {
    public Object postProcessBeforeInitialization(Object bean, String s) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String s) {
        Method[] methods = ReflectionUtils.getAllDeclaredMethods(bean.getClass());
        if (methods != null) {
            for (Method method : methods) {
                JobTask jobTask = (JobTask)AnnotationUtils.findAnnotation((Method)method, JobTask.class);
                if (jobTask == null) continue;
                if (!this.validParam(method, method.getGenericParameterTypes()[0])) {
                    throw new InvalidJobTaskMethodException(method);
                }
                ScheduleConsumer.addInvokeBean(jobTask.code(), new JobTaskInvokeBean(method, bean, jobTask));
            }
        }
        return bean;
    }

    private boolean validParam(Method method, Type param) {
        ParameterizedType parameterizedType;
        if (param instanceof ParameterizedType && (parameterizedType = (ParameterizedType)param).getRawType().equals(Map.class)) {
            Type[] args = parameterizedType.getActualTypeArguments();
            Class<?> returnType = method.getReturnType();
            return args[0].equals(String.class) && args[1].equals(Object.class) && (returnType.equals(Void.TYPE) || returnType.equals(Map.class));
        }
        return false;
    }
}

