/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.asgard.saga.producer.consistency;

import io.choerodon.asgard.saga.dto.SagaStatusQueryDTO;
import io.choerodon.asgard.saga.dto.StartInstanceDTO;
import io.choerodon.asgard.saga.exception.SagaProducerException;
import io.choerodon.asgard.saga.producer.consistency.SagaProducerConsistencyHandler;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class SagaProducerDbConsistencyHandler
extends SagaProducerConsistencyHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SagaProducerDbConsistencyHandler.class);
    private static final String INSERT_STATEMENT = "insert into asgard_producer_record SET uuid = ?, payload = ?, ref_type = ?, ref_id = ?, create_time = ?";
    private static final String DELETE_STATEMENT = "delete from asgard_producer_record where create_time + ? < ?";
    private static final String SELECT_STATEMENT = "select payload,ref_type,ref_id  from asgard_producer_record where uuid = ?";
    private final JdbcTemplate jdbcTemplate;

    public SagaProducerDbConsistencyHandler(ScheduledExecutorService executorService, DataSource dataSource) {
        super(executorService);
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    @Override
    public void beforeTransactionCommit(String uuid, StartInstanceDTO dto) {
        int row = this.jdbcTemplate.update(INSERT_STATEMENT, new Object[]{uuid, dto.getInput(), dto.getRefType(), dto.getRefId(), System.currentTimeMillis()});
        if (row != 1) {
            throw new SagaProducerException("error.saga.start.record");
        }
        LOGGER.trace("insert into asgard_producer_record,  UUID: {}", (Object)uuid);
    }

    @Override
    public void beforeTransactionCancel(String uuid) {
    }

    @Override
    public SagaStatusQueryDTO asgardServiceBackCheck(String uuid) {
        Map value = this.jdbcTemplate.queryForMap(SELECT_STATEMENT, new Object[]{uuid});
        if (value == null) {
            return new SagaStatusQueryDTO("cancel");
        }
        return new SagaStatusQueryDTO("confirm", (String)value.get("payload"), (String)value.get("ref_type"), (String)value.get("ref_id"));
    }

    @Override
    public void clear(long time) {
        int row = this.jdbcTemplate.update(DELETE_STATEMENT, new Object[]{time, System.currentTimeMillis()});
        if (row > 0) {
            LOGGER.info("clear asgard_producer_record createTime before: {} , number of deleted rows is: {}", (Object)time, (Object)row);
        }
    }
}

