/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.asgard.saga.producer;

import io.choerodon.asgard.saga.feign.SagaClient;
import io.choerodon.asgard.saga.producer.StartSagaBuilder;
import io.choerodon.asgard.saga.producer.TransactionalProducer;
import io.choerodon.asgard.saga.producer.consistency.SagaProducerConsistencyHandler;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class TransactionalProducerImpl
implements TransactionalProducer {
    private PlatformTransactionManager transactionManager;
    private SagaProducerConsistencyHandler consistencyHandler;
    private SagaClient sagaClient;
    private String service;

    public TransactionalProducerImpl(PlatformTransactionManager transactionManager, SagaProducerConsistencyHandler consistencyHandler, SagaClient sagaClient, String service) {
        this.transactionManager = transactionManager;
        this.consistencyHandler = consistencyHandler;
        this.sagaClient = sagaClient;
        this.service = service;
    }

    private String generateUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    @Override
    public <T> T applyAndReturn(StartSagaBuilder builder, Function<StartSagaBuilder, T> function) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(0);
        def.setIsolationLevel(-1);
        return this.applyAndReturn(builder, function, (TransactionDefinition)def);
    }

    @Override
    public void apply(StartSagaBuilder builder, Consumer<StartSagaBuilder> consumer) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(0);
        def.setIsolationLevel(-1);
        this.apply(builder, consumer, (TransactionDefinition)def);
    }

    @Override
    public <T> T applyAndReturn(StartSagaBuilder builder, Function<StartSagaBuilder, T> function, TransactionDefinition definition) {
        T result;
        String uuid = this.generateUUID();
        TransactionStatus status = this.transactionManager.getTransaction(definition);
        builder.withUuid(uuid).withService(this.service);
        try {
            this.sagaClient.preCreateSaga(builder.preBuild());
            result = function.apply(builder);
            this.consistencyHandler.beforeTransactionCommit(uuid, builder.confirmBuild());
            this.transactionManager.commit(status);
        }
        catch (Exception e) {
            this.consistencyHandler.beforeTransactionCancel(uuid);
            this.transactionManager.rollback(status);
            this.sagaClient.cancelSaga(uuid);
            throw e;
        }
        this.sagaClient.confirmSaga(uuid, builder.confirmBuild());
        return result;
    }

    @Override
    public void apply(StartSagaBuilder builder, Consumer<StartSagaBuilder> consumer, TransactionDefinition definition) {
        String uuid = this.generateUUID();
        TransactionStatus status = this.transactionManager.getTransaction(definition);
        builder.withUuid(uuid).withService(this.service);
        try {
            this.sagaClient.preCreateSaga(builder.preBuild());
            consumer.accept(builder);
            this.consistencyHandler.beforeTransactionCommit(uuid, builder.confirmBuild());
            this.transactionManager.commit(status);
        }
        catch (Exception e) {
            this.consistencyHandler.beforeTransactionCancel(uuid);
            this.transactionManager.rollback(status);
            this.sagaClient.cancelSaga(uuid);
            throw e;
        }
        this.sagaClient.confirmSaga(uuid, builder.confirmBuild());
    }
}

