/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.asgard.saga.consumer;

import io.choerodon.asgard.saga.annotation.SagaTask;
import io.choerodon.asgard.saga.consumer.SagaConsumer;
import io.choerodon.asgard.saga.consumer.SagaTaskInvokeBean;
import io.choerodon.asgard.saga.exception.SagaTaskCodeUniqueException;
import io.choerodon.asgard.saga.exception.SagaTaskMethodParameterException;
import java.lang.reflect.Method;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class SagaTaskProcessor
implements BeanPostProcessor {
    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        Method[] methods = ReflectionUtils.getAllDeclaredMethods(bean.getClass());
        if (methods != null) {
            for (Method method : methods) {
                SagaTask sagaTask = (SagaTask)AnnotationUtils.findAnnotation((Method)method, SagaTask.class);
                if (sagaTask == null) continue;
                String key = sagaTask.sagaCode() + sagaTask.code();
                this.errorCheck(method, sagaTask, key);
                SagaConsumer.invokeBeanMap.put(key, new SagaTaskInvokeBean(method, bean, sagaTask, key));
            }
        }
        return bean;
    }

    private void errorCheck(Method method, SagaTask sagaTask, String key) {
        if (method.getParameterCount() != 1 || !method.getParameterTypes()[0].equals(String.class)) {
            throw new SagaTaskMethodParameterException(method);
        }
        if (SagaConsumer.invokeBeanMap.entrySet().stream().anyMatch(t -> ((SagaTaskInvokeBean)t.getValue()).key.equals(key))) {
            throw new SagaTaskCodeUniqueException(sagaTask);
        }
    }
}

