/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.asgard.saga.consumer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class GenerateJsonSchemaUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenerateJsonSchemaUtil.class);

    private GenerateJsonSchemaUtil() {
    }

    public static String generate(Class<?> claz, ObjectMapper mapper, boolean emptyIsNull) {
        String value = "";
        try {
            value = mapper.writeValueAsString(GenerateJsonSchemaUtil.createExampleInstance(claz));
        }
        catch (JsonProcessingException e) {
            LOGGER.trace("GenerateJsonSchemaUtil jsonProcessingException {}", (Object)e.getMessage());
        }
        if (emptyIsNull && StringUtils.isEmpty((Object)value)) {
            return null;
        }
        return value;
    }

    static Object createExampleInstance(Class<?> claz) {
        if (claz == null) {
            return null;
        }
        if (claz.isArray() || Collection.class.isAssignableFrom(claz)) {
            return Collections.emptyList();
        }
        try {
            Object obj = claz.newInstance();
            ArrayList<Field> fieldList = new ArrayList<Field>();
            GenerateJsonSchemaUtil.getAllFields(fieldList, claz);
            for (Field field : fieldList) {
                Class<?> type = field.getType();
                if (type.equals(Boolean.class)) {
                    GenerateJsonSchemaUtil.setter(obj, field.getName(), true, type);
                    continue;
                }
                if (type.equals(Byte.class)) {
                    GenerateJsonSchemaUtil.setter(obj, field.getName(), new Byte("0"), type);
                    continue;
                }
                if (type.equals(Short.class)) {
                    GenerateJsonSchemaUtil.setter(obj, field.getName(), new Short("0"), type);
                    continue;
                }
                if (type.equals(Integer.class)) {
                    GenerateJsonSchemaUtil.setter(obj, field.getName(), 0, type);
                    continue;
                }
                if (type.equals(Long.class)) {
                    GenerateJsonSchemaUtil.setter(obj, field.getName(), 0L, type);
                    continue;
                }
                if (type.equals(Float.class)) {
                    GenerateJsonSchemaUtil.setter(obj, field.getName(), Float.valueOf(0.0f), type);
                    continue;
                }
                if (type.equals(Double.class)) {
                    GenerateJsonSchemaUtil.setter(obj, field.getName(), 0.0, type);
                    continue;
                }
                if (type.equals(String.class)) {
                    GenerateJsonSchemaUtil.setter(obj, field.getName(), "string", type);
                    continue;
                }
                if (type.isPrimitive()) continue;
                Object value = GenerateJsonSchemaUtil.createExampleInstance(field.getType());
                GenerateJsonSchemaUtil.setter(obj, field.getName(), value, type);
            }
            return obj;
        }
        catch (Exception e) {
            LOGGER.trace("generate json example data error when createInstance, class {}, cause {}", claz, (Object)e);
            return null;
        }
    }

    private static void getAllFields(List<Field> fieldList, Class<?> clazz) {
        if (clazz != null) {
            fieldList.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
            GenerateJsonSchemaUtil.getAllFields(fieldList, clazz);
        }
    }

    private static void setter(Object obj, String att, Object value, Class<?> type) {
        try {
            Method met = obj.getClass().getMethod("set" + GenerateJsonSchemaUtil.toUpperCaseFirstOne(att), type);
            if (met != null) {
                met.invoke(obj, value);
            }
        }
        catch (Exception e) {
            LOGGER.trace("generate json example data error when invoke setter, filed {} setValue {} cause {}", new Object[]{att, value, e});
        }
    }

    private static String toUpperCaseFirstOne(String s) {
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }
}

