/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.asgard.property;

import io.choerodon.asgard.schedule.ParamType;
import io.choerodon.asgard.schedule.annotation.JobParam;
import io.choerodon.asgard.schedule.exception.JobParamDefaultValueParseException;
import io.choerodon.asgard.schedule.exception.NotSupportParamTypeException;
import java.lang.reflect.InvocationTargetException;

public class PropertyJobParam {
    private String name;
    private Object defaultValue;
    private String type;
    private String description;

    PropertyJobParam(JobParam jobParam) {
        this.name = jobParam.name();
        this.type = this.getParamTypeByClass(jobParam.type()).getValue();
        if (!"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n".equals(jobParam.defaultValue())) {
            try {
                this.defaultValue = jobParam.type().getConstructor(String.class).newInstance(jobParam.defaultValue());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new JobParamDefaultValueParseException(e, jobParam.type(), jobParam.defaultValue());
            }
        }
        this.description = jobParam.description();
    }

    public PropertyJobParam() {
    }

    private ParamType getParamTypeByClass(Class<?> claz) {
        if (claz.equals(String.class)) {
            return ParamType.STRING;
        }
        if (claz.equals(Integer.class)) {
            return ParamType.INTEGER;
        }
        if (claz.equals(Long.class)) {
            return ParamType.LONG;
        }
        if (claz.equals(Double.class)) {
            return ParamType.DOUBLE;
        }
        if (claz.equals(Boolean.class)) {
            return ParamType.BOOLEAN;
        }
        throw new NotSupportParamTypeException(claz);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

