/*
 * Decompiled with CFR 0.152.
 */
package io.choerodon.asgard.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.choerodon.asgard.common.ApplicationContextHelper;
import io.choerodon.asgard.saga.consumer.MockHttpServletRequest;
import io.choerodon.core.oauth.CustomUserDetails;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.StringUtils;

public abstract class AbstractAsgardConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAsgardConsumer.class);
    protected final Set<Long> runningTasks = new ConcurrentSkipListSet<Long>();
    protected final String service;
    protected final String instance;
    protected final ObjectMapper objectMapper = new ObjectMapper();
    protected final PlatformTransactionManager transactionManager;
    protected final Executor executor;
    private final ApplicationContextHelper applicationContextHelper;

    public AbstractAsgardConsumer(String service, String instance, PlatformTransactionManager transactionManager, Executor executor, ScheduledExecutorService scheduledExecutorService, ApplicationContextHelper applicationContextHelper, long pollIntervalMs) {
        this.service = service;
        this.instance = instance;
        this.transactionManager = transactionManager;
        this.executor = executor;
        this.applicationContextHelper = applicationContextHelper;
        scheduledExecutorService.scheduleWithFixedDelay(() -> {
            try {
                this.scheduleRunning(instance);
            }
            catch (Exception e) {
                LOGGER.warn("error.asgard.scheduleRunning, msg: {}", (Object)e.getMessage());
            }
        }, 20000L, pollIntervalMs, TimeUnit.MILLISECONDS);
    }

    protected abstract void scheduleRunning(String var1);

    protected void beforeInvoke(CustomUserDetails customUserDetails) {
        if (customUserDetails == null) {
            customUserDetails = new CustomUserDetails("default", "unknown", Collections.emptyList());
            customUserDetails.setUserId(Long.valueOf(0L));
            customUserDetails.setOrganizationId(Long.valueOf(0L));
            customUserDetails.setLanguage("zh_CN");
            customUserDetails.setTimeZone("CCT");
        }
        UsernamePasswordAuthenticationToken user = new UsernamePasswordAuthenticationToken((Object)"default", (Object)"N/A", Collections.emptyList());
        OAuth2Request request = new OAuth2Request(new HashMap(0), "", Collections.emptyList(), true, Collections.emptySet(), Collections.emptySet(), null, null, null);
        OAuth2Authentication authentication = new OAuth2Authentication(request, (Authentication)user);
        OAuth2AuthenticationDetails oAuth2AuthenticationDetails = new OAuth2AuthenticationDetails((HttpServletRequest)new MockHttpServletRequest());
        oAuth2AuthenticationDetails.setDecodedDetails((Object)customUserDetails);
        authentication.setDetails((Object)oAuth2AuthenticationDetails);
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
    }

    protected void afterInvoke() {
        SecurityContextHolder.clearContext();
    }

    protected PlatformTransactionManager getSagaTaskTransactionManager(String transactionManagerName) {
        PlatformTransactionManager platformTransactionManager = StringUtils.isEmpty((Object)transactionManagerName) ? this.transactionManager : (PlatformTransactionManager)this.applicationContextHelper.getSpringFactory().getBean(transactionManagerName, PlatformTransactionManager.class);
        return platformTransactionManager;
    }

    protected TransactionStatus createTransactionStatus(PlatformTransactionManager transactionManager, int isolationLevel) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(0);
        def.setIsolationLevel(isolationLevel);
        return transactionManager.getTransaction((TransactionDefinition)def);
    }
}

