/*
 * Decompiled with CFR 0.152.
 */
package io.apimatic.core;

import io.apimatic.coreinterfaces.http.request.MutliPartRequestType;
import io.apimatic.coreinterfaces.type.functional.Serializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class Parameter {
    private final String key;
    private final Object value;
    private final Serializer multipartSerializer;
    private final boolean isRequired;
    private final boolean shouldEncode;
    private final MutliPartRequestType multiPartRequestType;
    private final Map<String, List<String>> multipartHeaders;

    private Parameter(String key, Object value, Serializer multipartSerializer, boolean isRequired, boolean shouldEncode, MutliPartRequestType multiPartRequest, Map<String, List<String>> multipartHeaders) {
        this.key = key;
        this.value = value;
        this.multipartSerializer = multipartSerializer;
        this.isRequired = isRequired;
        this.shouldEncode = shouldEncode;
        this.multiPartRequestType = multiPartRequest;
        this.multipartHeaders = multipartHeaders;
    }

    public String getKey() {
        return this.key;
    }

    public boolean shouldEncode() {
        return this.shouldEncode;
    }

    public Object getValue() {
        return this.value;
    }

    public Serializer getMultipartSerializer() {
        return this.multipartSerializer;
    }

    public MutliPartRequestType getMultiPartRequest() {
        return this.multiPartRequestType;
    }

    public Map<String, List<String>> getMultipartHeaders() {
        return this.multipartHeaders;
    }

    public void validate() {
        if (this.isRequired && null == this.value) {
            throw new NullPointerException("The parameter value is a required parameter and cannot be null.");
        }
    }

    public static class Builder {
        private String key;
        private Object value;
        private Serializer multipartSerializer;
        private boolean isRequired = true;
        private boolean shouldEncode;
        private MutliPartRequestType multiPartRequestType = null;
        private Map<String, List<String>> multipartHeaders = new HashMap<String, List<String>>();

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder value(Object value) {
            this.value = value;
            return this;
        }

        public Builder multipartSerializer(Serializer multipartSerializer) {
            this.multipartSerializer = multipartSerializer;
            return this;
        }

        public Builder isRequired(boolean isRequired) {
            this.isRequired = isRequired;
            return this;
        }

        public Builder shouldEncode(boolean shouldEncode) {
            this.shouldEncode = shouldEncode;
            return this;
        }

        public Builder multiPartRequestType(MutliPartRequestType multiPartRequestType) {
            this.multiPartRequestType = multiPartRequestType;
            return this;
        }

        public Builder multipartHeaders(String key, String value) {
            if (this.multipartHeaders.containsKey(key)) {
                this.multipartHeaders.get(key).add(value);
            } else {
                ArrayList<String> headerValues = new ArrayList<String>();
                headerValues.add(value);
                this.multipartHeaders.put(key, headerValues);
            }
            return this;
        }

        public Parameter build() {
            return new Parameter(this.key, this.value, this.multipartSerializer, this.isRequired, this.shouldEncode, this.multiPartRequestType, this.multipartHeaders);
        }
    }
}

