/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.treeprinter;

import hu.webarticum.treeprinter.AbstractTreePrinter;
import hu.webarticum.treeprinter.TreeNode;
import hu.webarticum.treeprinter.UnicodeMode;
import hu.webarticum.treeprinter.Util;
import java.util.Collections;
import java.util.List;

public class ListingTreePrinter
extends AbstractTreePrinter {
    public static final String[] LINE_STRINGS_ASCII = new String[]{"   ", " | ", " |-", " '-", "---"};
    public static final String[] LINE_STRINGS_UNICODE = new String[]{"   ", " \u2502 ", " \u251c\u2500", " \u2514\u2500", "\u2500\u2500\u2500"};
    private static final int NODE_ROOT = 0;
    private static final int NODE_GENERAL = 1;
    private static final int NODE_LAST = 2;
    private final String liningSpace;
    private final String liningGeneral;
    private final String liningNode;
    private final String liningLastNode;
    private final String liningInset;
    private final boolean displayRoot;
    private final boolean align;

    public ListingTreePrinter() {
        this(true, false);
    }

    public ListingTreePrinter(boolean useUnicode) {
        this(useUnicode, true, false);
    }

    public ListingTreePrinter(boolean displayRoot, boolean align) {
        this(UnicodeMode.isUnicodeDefault(), displayRoot, align);
    }

    public ListingTreePrinter(boolean useUnicode, boolean displayRoot, boolean align) {
        this((useUnicode ? LINE_STRINGS_UNICODE : LINE_STRINGS_ASCII)[0], (useUnicode ? LINE_STRINGS_UNICODE : LINE_STRINGS_ASCII)[1], (useUnicode ? LINE_STRINGS_UNICODE : LINE_STRINGS_ASCII)[2], (useUnicode ? LINE_STRINGS_UNICODE : LINE_STRINGS_ASCII)[3], (useUnicode ? LINE_STRINGS_UNICODE : LINE_STRINGS_ASCII)[4], displayRoot, align);
    }

    public ListingTreePrinter(String liningSpace, String liningGeneral, String liningNode, String liningLastNode, String liningInset, boolean displayRoot, boolean align) {
        this.liningSpace = liningSpace;
        this.liningGeneral = liningGeneral;
        this.liningNode = liningNode;
        this.liningLastNode = liningLastNode;
        this.liningInset = liningInset;
        this.displayRoot = displayRoot;
        this.align = align;
    }

    @Override
    public void print(TreeNode rootNode, Appendable out) {
        this.printSub(rootNode, out, "", 0, this.align ? Util.getDepth(rootNode) : 0);
    }

    private void printSub(TreeNode node, Appendable out, String prefix, int type, int inset) {
        String content = node.getContent();
        int connectOffset = node.getInsets()[0];
        String[] lines = content.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String itemPrefix;
            String line = lines[i];
            if (type == 0) {
                if (!this.displayRoot) continue;
                this.writeln(out, prefix + line);
                continue;
            }
            if (i < connectOffset) {
                itemPrefix = this.liningGeneral;
            } else if (i == connectOffset) {
                itemPrefix = type == 2 ? this.liningLastNode : this.liningNode;
            } else {
                String string = itemPrefix = type == 2 ? this.liningSpace : this.liningGeneral;
            }
            if (inset > 0) {
                String insetString = i == connectOffset ? this.liningInset : this.liningSpace;
                StringBuilder insetBuilder = new StringBuilder();
                for (int j = 0; j < inset; ++j) {
                    insetBuilder.append(insetString);
                }
                itemPrefix = itemPrefix + insetBuilder.toString();
            }
            this.writeln(out, prefix + itemPrefix + line);
        }
        List<TreeNode> childNodes = node.getChildren();
        childNodes.removeAll(Collections.singleton(null));
        int childNodeCount = childNodes.size();
        for (int i = 0; i < childNodeCount; ++i) {
            TreeNode childNode = childNodes.get(i);
            boolean childIsLast = i == childNodeCount - 1;
            String lining = type == 2 ? this.liningSpace : this.liningGeneral;
            String subPrefix = type == 0 ? prefix : prefix + lining;
            int subInset = Math.max(0, inset - 1);
            this.printSub(childNode, out, subPrefix, childIsLast ? 2 : 1, subInset);
        }
    }

    public static Builder createBuilder() {
        return new Builder();
    }

    public static class Builder {
        private boolean displayRoot = true;
        private boolean align = false;
        private String[] lines = (String[])(UnicodeMode.isUnicodeDefault() ? LINE_STRINGS_UNICODE : LINE_STRINGS_ASCII).clone();

        public Builder displayRoot(boolean displayRoot) {
            this.displayRoot = displayRoot;
            return this;
        }

        public Builder align(boolean align) {
            this.align = align;
            return this;
        }

        public Builder ascii() {
            this.lines = (String[])LINE_STRINGS_ASCII.clone();
            return this;
        }

        public Builder unicode() {
            this.lines = (String[])LINE_STRINGS_UNICODE.clone();
            return this;
        }

        public Builder lining(String space, String general, String node, String lastNode, String inset) {
            this.lines = new String[]{space, general, node, lastNode, inset};
            return this;
        }

        public Builder liningSpace(String liningSpace) {
            this.lines[0] = liningSpace;
            return this;
        }

        public Builder liningGeneral(String liningGeneral) {
            this.lines[1] = liningGeneral;
            return this;
        }

        public Builder liningNode(String liningNode) {
            this.lines[2] = liningNode;
            return this;
        }

        public Builder liningLastNode(String liningLastNode) {
            this.lines[3] = liningLastNode;
            return this;
        }

        public Builder liningInset(String liningInset) {
            this.lines[4] = liningInset;
            return this;
        }

        public ListingTreePrinter build() {
            return new ListingTreePrinter(this.lines[0], this.lines[1], this.lines[2], this.lines[3], this.lines[4], this.displayRoot, this.align);
        }
    }
}

