/*
 * Decompiled with CFR 0.152.
 */
package hu.webarticum.treeprinter;

import hu.webarticum.treeprinter.AbstractTreeNode;
import hu.webarticum.treeprinter.TreeNode;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTreeNodeDecorator
extends AbstractTreeNode {
    protected final TreeNode decoratedNode;
    protected final boolean decorable;
    protected final boolean inherit;
    protected final boolean forceInherit;

    public AbstractTreeNodeDecorator(TreeNode decoratedNode) {
        this(decoratedNode, decoratedNode.isDecorable(), true, false);
    }

    public AbstractTreeNodeDecorator(TreeNode decoratedNode, boolean decorable) {
        this(decoratedNode, decorable, true, false);
    }

    public AbstractTreeNodeDecorator(TreeNode decoratedNode, boolean decorable, boolean inherit) {
        this(decoratedNode, decorable, inherit, false);
    }

    public AbstractTreeNodeDecorator(TreeNode decoratedNode, boolean decorable, boolean inherit, boolean forceInherit) {
        this.decoratedNode = decoratedNode;
        this.decorable = decorable;
        this.inherit = inherit;
        this.forceInherit = forceInherit;
    }

    public TreeNode getDecoratedNode() {
        return this.decoratedNode;
    }

    @Override
    public TreeNode getOriginalNode() {
        return this.decoratedNode.getOriginalNode();
    }

    @Override
    public int[] getInsets() {
        return this.decoratedNode.getInsets();
    }

    @Override
    public boolean isDecorable() {
        return this.decorable;
    }

    @Override
    public List<TreeNode> getChildren() {
        ArrayList<TreeNode> decoratedChildren = new ArrayList<TreeNode>();
        for (TreeNode childNode : this.decoratedNode.getChildren()) {
            if (childNode == null) {
                decoratedChildren.add(null);
                continue;
            }
            if (this.inherit && (this.forceInherit || childNode.isDecorable())) {
                decoratedChildren.add(this.decorateChild(childNode));
                continue;
            }
            decoratedChildren.add(childNode);
        }
        return decoratedChildren;
    }

    protected abstract TreeNode decorateChild(TreeNode var1);
}

