/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.boot.config;

import cn.smallbun.screw.boot.properties.ScrewProperties;
import cn.smallbun.screw.core.Configuration;
import cn.smallbun.screw.core.engine.EngineConfig;
import cn.smallbun.screw.core.execute.DocumentationExecute;
import cn.smallbun.screw.core.process.ProcessConfig;
import java.io.ByteArrayOutputStream;
import javax.sql.DataSource;

public class Screw {
    private final ScrewProperties screwProperties;

    public ByteArrayOutputStream documentGeneration(String dsName, DataSource dataSource) {
        return this.documentGeneration(dsName, dataSource, this.screwProperties);
    }

    public ByteArrayOutputStream documentGeneration(String dsName, DataSource dataSource, ScrewProperties screwProperties) {
        Configuration config = Configuration.builder().organization(screwProperties.getOrganization()).organizationUrl(screwProperties.getOrganizationUrl()).title(screwProperties.getTitle()).version(screwProperties.getVersion()).description(screwProperties.getDescription()).dataSource(dataSource).engineConfig(this.getEngineConfig()).produceConfig(this.getProcessConfig()).build();
        return new DocumentationExecute(config).execute(dsName);
    }

    private EngineConfig getEngineConfig() {
        return EngineConfig.builder().fileType(this.screwProperties.getFileType()).produceType(this.screwProperties.getProduceType()).customTemplate(this.screwProperties.getTemplate()).fileName(this.screwProperties.getFileName()).build();
    }

    private ProcessConfig getProcessConfig() {
        return ProcessConfig.builder().ignoreTableName(this.screwProperties.getIgnoreTableName()).ignoreTablePrefix(this.screwProperties.getIgnoreTablePrefix()).ignoreTableSuffix(this.screwProperties.getIgnoreTableSuffix()).designatedTableName(this.screwProperties.getDesignatedTableName()).designatedTablePrefix(this.screwProperties.getDesignatedTablePrefix()).designatedTableSuffix(this.screwProperties.getDesignatedTableSuffix()).build();
    }

    public Screw(ScrewProperties screwProperties) {
        this.screwProperties = screwProperties;
    }
}

