/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.elasticsearch.tools.type;

import fr.pilato.elasticsearch.tools.type.TypeSettingsReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.client.Client;

public class TypeElasticsearchUpdater {
    private static final Logger logger = LogManager.getLogger(TypeElasticsearchUpdater.class);

    public static void createMapping(Client client, String index, String type, boolean merge, boolean force) throws Exception {
        String mapping = TypeSettingsReader.readMapping(index, type);
        TypeElasticsearchUpdater.createMappingWithJson(client, index, type, mapping, merge, force);
    }

    public static void createMapping(Client client, String root, String index, String type, boolean merge, boolean force) throws Exception {
        String mapping = TypeSettingsReader.readMapping(root, index, type);
        TypeElasticsearchUpdater.createMappingWithJson(client, index, type, mapping, merge, force);
    }

    public static void createMappingWithJson(Client client, String index, String type, String mapping, boolean merge, boolean force) throws Exception {
        if (force && TypeElasticsearchUpdater.isTypeExist(client, index, type)) {
            TypeElasticsearchUpdater.removeType(client, index, type);
        }
        boolean mappingExist = TypeElasticsearchUpdater.isTypeExist(client, index, type);
        if (merge || !mappingExist) {
            if (mappingExist) {
                logger.debug("Updating type [{}]/[{}].", new Object[]{index, type});
            } else {
                logger.debug("Type [{}]/[{}] doesn't exist. Creating it.", new Object[]{index, type});
            }
            TypeElasticsearchUpdater.createTypeWithMappingInElasticsearch(client, index, type, mapping);
        } else {
            logger.debug("Type [{}/{}] already exists and merge is not set.", new Object[]{index, type});
        }
        if (mappingExist) {
            logger.debug("Type definition for [{}]/[{}] succesfully merged.", new Object[]{index, type});
        } else {
            logger.debug("Type definition for [{}]/[{}] succesfully created.", new Object[]{index, type});
        }
    }

    public static boolean isTypeExist(Client client, String index, String type) throws Exception {
        return !((GetMappingsResponse)((GetMappingsRequestBuilder)client.admin().indices().prepareGetMappings(new String[]{index}).setTypes(new String[]{type})).get()).getMappings().isEmpty();
    }

    public static void removeType(Client client, String index, String type) throws Exception {
        logger.debug("Remove mapping [{}]/[{}]", new Object[]{index, type});
        client.admin().indices().prepareDeleteMapping(new String[]{index}).setType(new String[]{type}).get();
        client.admin().cluster().prepareHealth(new String[]{index}).setWaitForYellowStatus().get();
    }

    private static void createTypeWithMappingInElasticsearch(Client client, String index, String type, String mapping) throws Exception {
        logger.trace("createType([{}/{}])", new Object[]{index, type});
        assert (client != null);
        assert (index != null);
        assert (type != null);
        if (mapping != null) {
            PutMappingResponse mappingResponse = (PutMappingResponse)client.admin().indices().preparePutMapping(new String[]{index}).setType(type).setSource(mapping).get();
            if (!mappingResponse.isAcknowledged()) {
                logger.warn("Could not create type [{}/{}]", new Object[]{index, type});
                throw new Exception("Could not create type [" + index + "/" + type + "].");
            }
        } else {
            logger.trace("no content given for mapping. Ignoring type [{}/{}] creation.", new Object[]{index, type});
        }
        logger.trace("/createType([{}/{}])", new Object[]{index, type});
    }
}

