/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.elasticsearch.tools.template;

import fr.pilato.elasticsearch.tools.template.TemplateSettingsReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateResponse;
import org.elasticsearch.client.Client;

public class TemplateElasticsearchUpdater {
    private static final Logger logger = LogManager.getLogger(TemplateElasticsearchUpdater.class);

    public static void createTemplate(Client client, String root, String template, boolean force) throws Exception {
        String json = TemplateSettingsReader.readTemplate(root, template);
        TemplateElasticsearchUpdater.createTemplateWithJson(client, template, json, force);
    }

    public static void createTemplate(Client client, String template, boolean force) throws Exception {
        String json = TemplateSettingsReader.readTemplate(template);
        TemplateElasticsearchUpdater.createTemplateWithJson(client, template, json, force);
    }

    public static void createTemplateWithJson(Client client, String template, String json, boolean force) throws Exception {
        if (TemplateElasticsearchUpdater.isTemplateExist(client, template)) {
            if (force) {
                logger.debug("Template [{}] already exists. Force is set. Removing it.", new Object[]{template});
                TemplateElasticsearchUpdater.removeTemplate(client, template);
            } else {
                logger.debug("Template [{}] already exists.", new Object[]{template});
            }
        }
        if (!TemplateElasticsearchUpdater.isTemplateExist(client, template)) {
            logger.debug("Template [{}] doesn't exist. Creating it.", new Object[]{template});
            TemplateElasticsearchUpdater.createTemplateWithJsonInElasticsearch(client, template, json);
        }
    }

    private static void createTemplateWithJsonInElasticsearch(Client client, String template, String json) throws Exception {
        logger.trace("createTemplate([{}])", new Object[]{template});
        assert (client != null);
        assert (template != null);
        PutIndexTemplateResponse response = (PutIndexTemplateResponse)client.admin().indices().preparePutTemplate(template).setSource(json).get();
        if (!response.isAcknowledged()) {
            logger.warn("Could not create template [{}]", new Object[]{template});
            throw new Exception("Could not create template [" + template + "].");
        }
        logger.trace("/createTemplate([{}])", new Object[]{template});
    }

    public static boolean isTemplateExist(Client client, String template) {
        return !((GetIndexTemplatesResponse)client.admin().indices().prepareGetTemplates(new String[]{template}).get()).getIndexTemplates().isEmpty();
    }

    public static void removeTemplate(Client client, String template) throws Exception {
        logger.trace("removeTemplate({})", new Object[]{template});
        client.admin().indices().prepareDeleteTemplate(template).get();
        logger.trace("/removeTemplate({})", new Object[]{template});
    }
}

