/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.elasticsearch.tools.index;

import fr.pilato.elasticsearch.tools.SettingsFinder;
import fr.pilato.elasticsearch.tools.SettingsReader;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IndexSettingsReader
extends SettingsReader {
    private static final Logger logger = LogManager.getLogger(IndexSettingsReader.class);

    public static String readSettings(String root, String index, String jsonFile) {
        logger.trace("Reading [{}] for [{}] in [{}]...", new Object[]{jsonFile, index, root});
        String settingsFile = root + "/" + index + "/" + jsonFile;
        return IndexSettingsReader.readFileFromClasspath(settingsFile);
    }

    public static String readSettings(String root, String index) throws IOException {
        if (root == null) {
            return IndexSettingsReader.readSettings(index);
        }
        return IndexSettingsReader.readSettings(root, index, SettingsFinder.Defaults.IndexSettingsFileName);
    }

    public static String readSettings(String index) throws IOException {
        return IndexSettingsReader.readSettings(SettingsFinder.fromClasspath(SettingsFinder.Defaults.ConfigDir), index);
    }

    public static String readUpdateSettings(String root, String index) {
        return IndexSettingsReader.readSettings(root, index, SettingsFinder.Defaults.UpdateIndexSettingsFileName);
    }

    public static String readUpdateSettings(String index) throws IOException {
        return IndexSettingsReader.readUpdateSettings(SettingsFinder.fromClasspath(SettingsFinder.Defaults.ConfigDir), index);
    }
}

