/*
 * Decompiled with CFR 0.152.
 */
package fr.pilato.elasticsearch.tools;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceList {
    private static final Logger logger = LogManager.getLogger(ResourceList.class);
    private static final String[] NO_RESOURCE = new String[0];

    public static String[] getResources(String root) throws URISyntaxException, IOException {
        logger.trace("Reading classpath resources from {}", new Object[]{root});
        URL dirURL = ResourceList.class.getClassLoader().getResource(root);
        if (dirURL != null && dirURL.getProtocol().equals("file")) {
            logger.trace("found a file resource: {}", new Object[]{dirURL});
            return new File(dirURL.toURI()).list();
        }
        if (dirURL == null) {
            String me = ResourceList.class.getName().replace(".", "/") + ".class";
            dirURL = ResourceList.class.getClassLoader().getResource(me);
        }
        if (dirURL.getProtocol().equals("jar")) {
            logger.trace("found a jar file resource: {}", new Object[]{dirURL});
            String jarPath = dirURL.getPath().substring(5, dirURL.getPath().indexOf("!"));
            JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            Enumeration<JarEntry> entries = jar.entries();
            HashSet<String> result = new HashSet<String>();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.startsWith(root)) continue;
                String entry = name.substring(root.length());
                int checkSubdir = entry.indexOf("/");
                if (checkSubdir >= 0) {
                    entry = entry.substring(0, checkSubdir);
                }
                result.add(entry);
            }
            return result.toArray(new String[result.size()]);
        }
        logger.trace("did not find any resource. returning empty array");
        return NO_RESOURCE;
    }
}

