/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.xhtml.internal;

import fr.opensagres.poi.xwpf.converter.core.BorderSide;
import fr.opensagres.poi.xwpf.converter.core.Color;
import fr.opensagres.poi.xwpf.converter.core.IURIResolver;
import fr.opensagres.poi.xwpf.converter.core.ListItemContext;
import fr.opensagres.poi.xwpf.converter.core.Options;
import fr.opensagres.poi.xwpf.converter.core.TableCellBorder;
import fr.opensagres.poi.xwpf.converter.core.XWPFDocumentVisitor;
import fr.opensagres.poi.xwpf.converter.core.styles.XWPFStylesDocument;
import fr.opensagres.poi.xwpf.converter.core.styles.run.RunFontStyleStrikeValueProvider;
import fr.opensagres.poi.xwpf.converter.core.styles.run.RunTextHighlightingValueProvider;
import fr.opensagres.poi.xwpf.converter.core.utils.DxaUtil;
import fr.opensagres.poi.xwpf.converter.core.utils.StringUtils;
import fr.opensagres.poi.xwpf.converter.xhtml.XHTMLOptions;
import fr.opensagres.poi.xwpf.converter.xhtml.internal.XHTMLMasterPage;
import fr.opensagres.poi.xwpf.converter.xhtml.internal.styles.CSSStyle;
import fr.opensagres.poi.xwpf.converter.xhtml.internal.styles.CSSStylesDocument;
import fr.opensagres.poi.xwpf.converter.xhtml.internal.utils.SAXHelper;
import fr.opensagres.poi.xwpf.converter.xhtml.internal.utils.StringEscapeUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPictureData;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveSize2D;
import org.openxmlformats.schemas.drawingml.x2006.picture.CTPicture;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.STRelFromH;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.STRelFromV;
import org.openxmlformats.schemas.drawingml.x2006.wordprocessingDrawing.STWrapText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBookmark;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtrRef;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPTab;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPageMar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPageSz;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTabs;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPrBase;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XHTMLMapper
extends XWPFDocumentVisitor<Object, XHTMLOptions, XHTMLMasterPage> {
    static final String TAB_CHAR_SEQUENCE = "&nbsp;&nbsp;&nbsp;&nbsp;";
    private static final String WORD_MEDIA = "word/media/";
    private final ContentHandler contentHandler;
    private XWPFParagraph currentParagraph;
    private boolean generateStyles = true;
    private final IURIResolver resolver;
    private AttributesImpl currentRunAttributes;
    private boolean pageDiv;

    public XHTMLMapper(XWPFDocument document, ContentHandler contentHandler, XHTMLOptions options) throws Exception {
        super(document, (Options)(options != null ? options : XHTMLOptions.getDefault()));
        this.contentHandler = contentHandler;
        this.resolver = ((XHTMLOptions)this.getOptions()).getURIResolver();
        this.pageDiv = false;
    }

    protected XWPFStylesDocument createStylesDocument(XWPFDocument document) throws XmlException, IOException {
        return new CSSStylesDocument(document, ((XHTMLOptions)this.options).isIgnoreStylesIfUnused(), ((XHTMLOptions)this.options).getIndent());
    }

    protected Object startVisitDocument() throws Exception {
        if (!((XHTMLOptions)this.options).isFragment()) {
            this.contentHandler.startDocument();
            this.startElement("html");
            this.startElement("head");
            if (this.generateStyles) {
                ((CSSStylesDocument)this.stylesDocument).save(this.contentHandler);
            }
            this.endElement("head");
            this.startElement("body");
        }
        return null;
    }

    protected void endVisitDocument() throws Exception {
        if (this.pageDiv) {
            this.endElement("div");
        }
        if (!((XHTMLOptions)this.options).isFragment()) {
            this.endElement("body");
            this.endElement("html");
            this.contentHandler.endDocument();
        }
    }

    protected Object startVisitParagraph(XWPFParagraph paragraph, ListItemContext itemContext, Object parentContainer) throws Exception {
        AttributesImpl attributes = this.createClassAttribute(paragraph.getStyleID());
        CTPPr pPr = paragraph.getCTP().getPPr();
        CSSStyle cssStyle = this.getStylesDocument().createCSSStyle(pPr);
        attributes = this.createStyleAttribute(cssStyle, attributes);
        this.startElement("p", attributes);
        if (itemContext != null) {
            this.startElement("span", attributes);
            String text = itemContext.getText();
            if (StringUtils.isNotEmpty((String)text)) {
                text = StringUtils.replaceNonUnicodeChars((String)text);
                text = text + " ";
                SAXHelper.characters(this.contentHandler, StringEscapeUtils.escapeHtml(text));
            }
            this.endElement("span");
        }
        return null;
    }

    protected void endVisitParagraph(XWPFParagraph paragraph, Object parentContainer, Object paragraphContainer) throws Exception {
        this.endElement("p");
    }

    protected void visitRun(XWPFRun run, boolean pageNumber, String url, Object paragraphContainer) throws Exception {
        if (run.getParent() instanceof XWPFParagraph) {
            this.currentParagraph = (XWPFParagraph)run.getParent();
        }
        XWPFParagraph paragraph = run.getParagraph();
        this.currentRunAttributes = this.createClassAttribute(paragraph.getStyleID());
        CTRPr rPr = run.getCTR().getRPr();
        CSSStyle cssStyle = this.getStylesDocument().createCSSStyle(rPr);
        this.currentRunAttributes = this.createStyleAttribute(cssStyle, this.currentRunAttributes);
        if (url != null) {
            AttributesImpl hyperlinkAttributes = new AttributesImpl();
            SAXHelper.addAttrValue(hyperlinkAttributes, "href", url);
            this.startElement("a", hyperlinkAttributes);
        }
        super.visitRun(run, pageNumber, url, paragraphContainer);
        if (url != null) {
            this.characters(" ");
            this.endElement("a");
        }
        this.currentRunAttributes = null;
        this.currentParagraph = null;
    }

    protected void visitEmptyRun(Object paragraphContainer) throws Exception {
        this.startElement("br");
        this.endElement("br");
    }

    protected void visitText(CTText ctText, boolean pageNumber, Object paragraphContainer) throws Exception {
        String text;
        if (this.currentRunAttributes != null) {
            this.startElement("span", this.currentRunAttributes);
        }
        if (StringUtils.isNotEmpty((String)(text = ctText.getStringValue()))) {
            this.characters(StringEscapeUtils.escapeHtml(text));
        }
        if (this.currentRunAttributes != null) {
            this.endElement("span");
        }
    }

    protected void visitStyleText(XWPFRun run, String text) throws Exception {
        if (run.getFontFamily() == null) {
            run.setFontFamily(this.getStylesDocument().getFontFamilyAscii(run));
        }
        if (run.getFontSize() <= 0) {
            run.setFontSize(this.getStylesDocument().getFontSize(run).intValue());
        }
        CTRPr rPr = run.getCTR().getRPr();
        AttributesImpl runAttributes = this.createClassAttribute(this.currentParagraph.getStyleID());
        CSSStyle cssStyle = this.getStylesDocument().createCSSStyle(rPr);
        if (cssStyle != null) {
            Color color = RunTextHighlightingValueProvider.INSTANCE.getValue(rPr, (XWPFStylesDocument)this.getStylesDocument());
            if (color != null) {
                cssStyle.addProperty("background-color", StringUtils.toHexString((Color)color));
            }
            if (Boolean.TRUE.equals(RunFontStyleStrikeValueProvider.INSTANCE.getValue(rPr, (XWPFStylesDocument)this.getStylesDocument())) || rPr.getDstrike() != null) {
                cssStyle.addProperty("text-decoration", "line-through");
            }
            if (rPr.getVertAlign() != null) {
                int align = rPr.getVertAlign().getVal().intValue();
                if (2 == align) {
                    cssStyle.addProperty("vertical-align", "super");
                } else if (3 == align) {
                    cssStyle.addProperty("vertical-align", "sub");
                }
            }
        }
        if ((runAttributes = this.createStyleAttribute(cssStyle, runAttributes)) != null) {
            this.startElement("span", runAttributes);
        }
        if (StringUtils.isNotEmpty((String)text)) {
            this.characters(StringEscapeUtils.escapeHtml(text));
        }
        if (runAttributes != null) {
            this.endElement("span");
        }
    }

    protected void visitTab(CTPTab o, Object paragraphContainer) throws Exception {
    }

    protected void visitTabs(CTTabs tabs, Object paragraphContainer) throws Exception {
        if (this.currentParagraph != null && tabs == null) {
            this.startElement("span", null);
            this.characters(TAB_CHAR_SEQUENCE);
            this.endElement("span");
            return;
        }
    }

    protected void addNewLine(CTBr br, Object paragraphContainer) throws Exception {
        this.startElement("br");
        this.endElement("br");
    }

    protected void pageBreak() throws Exception {
    }

    protected void visitBookmark(CTBookmark bookmark, XWPFParagraph paragraph, Object paragraphContainer) throws Exception {
        AttributesImpl attributes = new AttributesImpl();
        SAXHelper.addAttrValue(attributes, "id", bookmark.getName());
        this.startElement("span", attributes);
        this.endElement("span");
    }

    protected Object startVisitTable(XWPFTable table, float[] colWidths, Object tableContainer) throws Exception {
        AttributesImpl attributes = this.createClassAttribute(table.getStyleID());
        CTTblPr tblPr = table.getCTTbl().getTblPr();
        CSSStyle cssStyle = this.getStylesDocument().createCSSStyle((CTTblPrBase)tblPr);
        if (cssStyle != null) {
            cssStyle.addProperty("border-collapse", "collapse");
        }
        attributes = this.createStyleAttribute(cssStyle, attributes);
        this.startElement("table", attributes);
        return null;
    }

    protected void endVisitTable(XWPFTable table, Object parentContainer, Object tableContainer) throws Exception {
        this.endElement("table");
    }

    protected void startVisitTableRow(XWPFTableRow row, Object tableContainer, int rowIndex, boolean headerRow) throws Exception {
        XWPFTable table = row.getTable();
        AttributesImpl attributes = this.createClassAttribute(table.getStyleID());
        if (headerRow) {
            this.startElement("th", attributes);
        } else {
            this.startElement("tr", attributes);
        }
    }

    protected void endVisitTableRow(XWPFTableRow row, Object tableContainer, boolean firstRow, boolean lastRow, boolean headerRow) throws Exception {
        if (headerRow) {
            this.endElement("th");
        } else {
            this.endElement("tr");
        }
    }

    protected Object startVisitTableCell(XWPFTableCell cell, Object tableContainer, boolean firstRow, boolean lastRow, boolean firstCell, boolean lastCell, List<XWPFTableCell> vMergeCells) throws Exception {
        XWPFTableRow row = cell.getTableRow();
        XWPFTable table = row.getTable();
        AttributesImpl attributes = this.createClassAttribute(table.getStyleID());
        CTTcPr tcPr = cell.getCTTc().getTcPr();
        CSSStyle cssStyle = this.getStylesDocument().createCSSStyle(tcPr);
        if (cssStyle != null) {
            String style;
            TableCellBorder border = this.getStylesDocument().getTableBorder(table, BorderSide.TOP);
            if (border != null) {
                style = border.getBorderSize() + "px solid " + StringUtils.toHexString((Color)border.getBorderColor());
                cssStyle.addProperty("border-top", style);
            }
            if ((border = this.getStylesDocument().getTableBorder(table, BorderSide.BOTTOM)) != null) {
                style = border.getBorderSize() + "px solid " + StringUtils.toHexString((Color)border.getBorderColor());
                cssStyle.addProperty("border-bottom", style);
            }
            if ((border = this.getStylesDocument().getTableBorder(table, BorderSide.LEFT)) != null) {
                style = border.getBorderSize() + "px solid " + StringUtils.toHexString((Color)border.getBorderColor());
                cssStyle.addProperty("border-left", style);
            }
            if ((border = this.getStylesDocument().getTableBorder(table, BorderSide.RIGHT)) != null) {
                style = border.getBorderSize() + "px solid " + StringUtils.toHexString((Color)border.getBorderColor());
                cssStyle.addProperty("border-right", style);
            }
        }
        attributes = this.createStyleAttribute(cssStyle, attributes);
        BigInteger gridSpan = this.stylesDocument.getTableCellGridSpan(cell);
        if (gridSpan != null) {
            attributes = SAXHelper.addAttrValue(attributes, "colspan", gridSpan.intValue());
        }
        if (vMergeCells != null) {
            attributes = SAXHelper.addAttrValue(attributes, "rowspan", vMergeCells.size());
        }
        this.startElement("td", attributes);
        return null;
    }

    protected void endVisitTableCell(XWPFTableCell cell, Object tableContainer, Object tableCellContainer) throws Exception {
        this.endElement("td");
    }

    protected void visitHeader(XWPFHeader header, CTHdrFtrRef headerRef, CTSectPr sectPr, XHTMLMasterPage masterPage) throws Exception {
    }

    protected void visitFooter(XWPFFooter footer, CTHdrFtrRef footerRef, CTSectPr sectPr, XHTMLMasterPage masterPage) throws Exception {
    }

    protected void visitPicture(CTPicture picture, Float offsetX, STRelFromH.Enum relativeFromH, Float offsetY, STRelFromV.Enum relativeFromV, STWrapText.Enum wrapText, Object parentContainer) throws Exception {
        AttributesImpl attributes = null;
        XWPFPictureData pictureData = super.getPictureData(picture);
        if (pictureData != null) {
            String src = pictureData.getFileName();
            if (StringUtils.isNotEmpty((String)src)) {
                src = this.resolver.resolve(WORD_MEDIA + src);
                attributes = SAXHelper.addAttrValue(attributes, "src", src);
            }
            CTPositiveSize2D ext = picture.getSpPr().getXfrm().getExt();
            float width = DxaUtil.emu2points((long)ext.getCx());
            attributes = SAXHelper.addAttrValue(attributes, "width", this.getStylesDocument().getValueAsPoint(width));
            float height = DxaUtil.emu2points((long)ext.getCy());
            attributes = SAXHelper.addAttrValue(attributes, "height", this.getStylesDocument().getValueAsPoint(height));
        } else {
            String link = picture.getBlipFill().getBlip().getLink();
            String src = this.document.getPackagePart().getRelationships().getRelationshipByID(link).getTargetURI().toString();
            attributes = SAXHelper.addAttrValue(null, "src", src);
            CTPositiveSize2D ext = picture.getSpPr().getXfrm().getExt();
            float width = DxaUtil.emu2points((long)ext.getCx());
            attributes = SAXHelper.addAttrValue(attributes, "width", this.getStylesDocument().getValueAsPoint(width));
            float height = DxaUtil.emu2points((long)ext.getCy());
            attributes = SAXHelper.addAttrValue(attributes, "height", this.getStylesDocument().getValueAsPoint(height));
        }
        if (attributes != null) {
            this.startElement("img", attributes);
            this.endElement("img");
        }
    }

    public void setActiveMasterPage(XHTMLMasterPage masterPage) {
        String s;
        CTPageMar pageMargin;
        BigInteger width;
        if (this.pageDiv) {
            try {
                this.endElement("div");
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }
        AttributesImpl attributes = new AttributesImpl();
        CSSStyle style = new CSSStyle("div", null);
        CTSectPr sectPr = masterPage.getSectPr();
        CTPageSz pageSize = sectPr.getPgSz();
        if (pageSize != null && (width = pageSize.getW()) != null) {
            style.addProperty("width", this.getStylesDocument().getValueAsPoint(DxaUtil.dxa2points((BigInteger)width)));
        }
        if ((pageMargin = sectPr.getPgMar()) != null) {
            BigInteger marginRight;
            BigInteger marginLeft;
            BigInteger marginTop;
            BigInteger marginBottom = pageMargin.getBottom();
            if (marginBottom != null) {
                float marginBottomPt = DxaUtil.dxa2points((BigInteger)marginBottom);
                style.addProperty("margin-bottom", this.getStylesDocument().getValueAsPoint(marginBottomPt));
            }
            if ((marginTop = pageMargin.getTop()) != null) {
                float marginTopPt = DxaUtil.dxa2points((BigInteger)marginTop);
                style.addProperty("margin-top", this.getStylesDocument().getValueAsPoint(marginTopPt));
            }
            if ((marginLeft = pageMargin.getLeft()) != null) {
                float marginLeftPt = DxaUtil.dxa2points((BigInteger)marginLeft);
                style.addProperty("margin-left", this.getStylesDocument().getValueAsPoint(marginLeftPt));
            }
            if ((marginRight = pageMargin.getRight()) != null) {
                float marginRightPt = DxaUtil.dxa2points((BigInteger)marginRight);
                style.addProperty("margin-right", this.getStylesDocument().getValueAsPoint(marginRightPt));
            }
        }
        if (StringUtils.isNotEmpty((String)(s = style.getInlineStyles()))) {
            SAXHelper.addAttrValue(attributes, "style", s);
        }
        try {
            this.startElement("div", attributes);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        this.pageDiv = true;
    }

    public XHTMLMasterPage createMasterPage(CTSectPr sectPr) {
        return new XHTMLMasterPage(sectPr);
    }

    private void startElement(String name) throws SAXException {
        this.startElement(name, null);
    }

    private void startElement(String name, Attributes attributes) throws SAXException {
        SAXHelper.startElement(this.contentHandler, name, attributes);
    }

    private void endElement(String name) throws SAXException {
        SAXHelper.endElement(this.contentHandler, name);
    }

    private void characters(String content) throws SAXException {
        SAXHelper.characters(this.contentHandler, content);
    }

    public CSSStylesDocument getStylesDocument() {
        return (CSSStylesDocument)super.getStylesDocument();
    }

    private AttributesImpl createClassAttribute(String styleID) {
        String classNames = this.getStylesDocument().getClassNames(styleID);
        if (StringUtils.isNotEmpty((String)classNames)) {
            return SAXHelper.addAttrValue(null, "class", classNames);
        }
        return null;
    }

    private AttributesImpl createStyleAttribute(CSSStyle cssStyle, AttributesImpl attributes) {
        String inlineStyles;
        if (cssStyle != null && StringUtils.isNotEmpty((String)(inlineStyles = cssStyle.getInlineStyles()))) {
            attributes = SAXHelper.addAttrValue(attributes, "style", inlineStyles);
        }
        return attributes;
    }
}

