/*
 * Decompiled with CFR 0.152.
 */
package fr.vergne.ioutils;

import fr.vergne.ioutils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class StringUtils {
    public static String join(Collection<? extends Object> elements, String separator) {
        Iterator<? extends Object> iterator = elements.iterator();
        if (iterator.hasNext()) {
            StringBuilder builder = new StringBuilder();
            builder.append(iterator.next().toString());
            while (iterator.hasNext()) {
                builder.append(separator);
                builder.append(iterator.next().toString());
            }
            return builder.toString();
        }
        return "";
    }

    public static String join(Collection<? extends Object> elements) {
        return StringUtils.join(elements, "");
    }

    public static String readFromFile(File file) throws IOException {
        return FileUtils.readFileToString(file);
    }

    public static String readFromInputStream(InputStream stream, Charset charset) throws IOException {
        int read;
        LinkedList<Byte> bytes = new LinkedList<Byte>();
        byte[] buffer = new byte[128];
        while ((read = stream.read(buffer)) != -1) {
            for (int i = 0; i < read; ++i) {
                bytes.add(buffer[i]);
            }
        }
        int total = bytes.size();
        buffer = new byte[total];
        for (int i = 0; i < total; ++i) {
            buffer[i] = (Byte)bytes.remove(0);
        }
        if (charset == null) {
            return new String(buffer);
        }
        return new String(buffer, charset);
    }

    public static String readFromInputStream(InputStream stream) throws IOException {
        return StringUtils.readFromInputStream(stream, null);
    }
}

