/*
 * Decompiled with CFR 0.152.
 */
package fr.jcgay.maven.profiler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import fr.jcgay.maven.profiler.ArtifactDescriptor;
import fr.jcgay.maven.profiler.Configuration;
import fr.jcgay.maven.profiler.KnownElapsedTimeTicker;
import fr.jcgay.maven.profiler.Statistics;
import fr.jcgay.maven.profiler.reporting.ReportDirectory;
import fr.jcgay.maven.profiler.reporting.template.Data;
import fr.jcgay.maven.profiler.reporting.template.EntryAndTime;
import fr.jcgay.maven.profiler.reporting.template.Project;
import fr.jcgay.maven.profiler.sorting.Sorter;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.maven.eventspy.AbstractEventSpy;
import org.apache.maven.eventspy.EventSpy;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.artifact.Artifact;

@Component(role=EventSpy.class, hint="profiler", description="Measure times taken by Maven.")
public class ProfilerEventSpy
extends AbstractEventSpy {
    private final Statistics statistics;
    private final Configuration configuration;
    private final Supplier<Date> now;
    @Requirement
    private Logger logger;

    public ProfilerEventSpy() {
        this.statistics = new Statistics();
        this.configuration = Configuration.read();
        this.now = Date::new;
    }

    @VisibleForTesting
    ProfilerEventSpy(Statistics statistics, Configuration configuration, Supplier<Date> now) {
        this.statistics = statistics;
        this.configuration = configuration;
        this.logger = new ConsoleLogger();
        this.now = now;
    }

    public void init(EventSpy.Context context) throws Exception {
        super.init(context);
        if (this.configuration.isProfiling()) {
            this.logger.info("Profiling mvn execution...");
        }
    }

    public void onEvent(Object event) throws Exception {
        super.onEvent(event);
        if (this.configuration.isProfiling()) {
            if (event instanceof DefaultMavenExecutionRequest) {
                DefaultMavenExecutionRequest mavenEvent = (DefaultMavenExecutionRequest)event;
                this.statistics.setGoals(new LinkedHashSet<String>(mavenEvent.getGoals()));
                this.statistics.setProperties(mavenEvent.getUserProperties());
            } else if (event instanceof ExecutionEvent) {
                this.storeExecutionEvent((ExecutionEvent)event);
                this.trySaveTopProject((ExecutionEvent)event);
                this.storeStartTime((ExecutionEvent)event);
            } else if (event instanceof RepositoryEvent) {
                this.storeDownloadingArtifacts((RepositoryEvent)event);
            }
        }
    }

    private void storeStartTime(ExecutionEvent event) {
        if (event.getType() == ExecutionEvent.Type.ProjectDiscoveryStarted) {
            this.statistics.setStartTime(event.getSession().getStartTime());
        }
    }

    public void close() throws Exception {
        super.close();
        if (this.configuration.isProfiling()) {
            Date finishTime = (Date)this.now.get();
            Data context = new Data().setProjects(this.sortedProjects()).setDate(finishTime).setTopProjectName(this.statistics.topProject().getName()).setProfileName(this.configuration.profileName()).setGoals(Joiner.on((char)' ').join(this.statistics.goals())).setParameters(this.statistics.properties());
            this.setDownloads(context);
            if (this.statistics.getStartTime() != null) {
                context.setBuildTime(KnownElapsedTimeTicker.aStopWatchWithElapsedTime(TimeUnit.MILLISECONDS.toNanos(finishTime.getTime() - this.statistics.getStartTime().getTime())));
            }
            this.configuration.reporter().write(context, new ReportDirectory(this.statistics.topProject()));
        }
    }

    private void trySaveTopProject(ExecutionEvent event) {
        if (event.getType() == ExecutionEvent.Type.SessionStarted) {
            this.statistics.setTopProject(event.getSession().getTopLevelProject());
        }
    }

    private List<Project> sortedProjects() {
        Sorter sorter = this.configuration.sorter();
        ArrayList<Project> result = new ArrayList<Project>();
        Map<MavenProject, Stopwatch> allProjectsWithTimer = this.statistics.projects();
        for (MavenProject project : sorter.projects(allProjectsWithTimer)) {
            Project currentProject = new Project(project.getName(), allProjectsWithTimer.get(project));
            for (Map.Entry<MojoExecution, Stopwatch> mojo : sorter.mojoExecutionsOf(project, this.statistics.executions())) {
                currentProject.addMojoTime(new EntryAndTime<MojoExecution>(mojo.getKey(), mojo.getValue()));
            }
            result.add(currentProject);
        }
        return result;
    }

    private void setDownloads(Data data) {
        Map<Artifact, Stopwatch> downloadedArtifacts = this.statistics.downloads();
        ArrayList<EntryAndTime<Artifact>> result = new ArrayList<EntryAndTime<Artifact>>();
        for (Artifact artifact : this.configuration.sorter().downloads(downloadedArtifacts)) {
            result.add(new EntryAndTime<Artifact>(artifact, downloadedArtifacts.get(artifact)));
        }
        data.setDownloads(result).setTotalDownloadTime(ArtifactDescriptor.instance(downloadedArtifacts).getTotalTimeSpentDownloadingArtifacts());
    }

    private void storeDownloadingArtifacts(RepositoryEvent event) {
        this.logger.debug(String.format("Received event (%s): %s", event.getClass(), event));
        if (event.getType() == RepositoryEvent.EventType.ARTIFACT_DOWNLOADING) {
            this.statistics.startDownload(event.getArtifact());
        } else if (event.getType() == RepositoryEvent.EventType.ARTIFACT_DOWNLOADED && ProfilerEventSpy.hasNoException(event)) {
            this.statistics.stopDownload(event.getArtifact());
        }
    }

    private static boolean hasNoException(RepositoryEvent event) {
        List exceptions = event.getExceptions();
        return exceptions == null || exceptions.isEmpty();
    }

    private void storeExecutionEvent(ExecutionEvent event) {
        this.logger.debug(String.format("Received event (%s): %s", event.getClass(), event));
        MavenProject currentProject = event.getSession().getCurrentProject();
        switch (event.getType()) {
            case ProjectStarted: {
                this.statistics.startProject(currentProject);
                break;
            }
            case ProjectSucceeded: 
            case ProjectFailed: {
                this.statistics.stopProject(currentProject);
                break;
            }
            case MojoStarted: {
                this.statistics.startExecution(currentProject, event.getMojoExecution());
                break;
            }
            case MojoSucceeded: 
            case MojoFailed: {
                this.statistics.stopExecution(currentProject, event.getMojoExecution());
            }
        }
    }
}

