/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.cssfx.impl.monitoring;

import com.sun.nio.file.SensitivityWatchEventModifier;
import fr.brouillard.oss.cssfx.impl.log.CSSFXLogger;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PathsWatcher {
    private WatchService watchService;
    private Map<String, Map<String, List<Runnable>>> filesActions = new HashMap<String, Map<String, List<Runnable>>>();
    private Thread watcherThread;

    public PathsWatcher() {
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            CSSFXLogger.logger(PathsWatcher.class).error("cannot create WatchService", e);
        }
    }

    public void monitor(Path directory, Path sourceFile, Runnable action) {
        if (this.watchService != null) {
            CSSFXLogger.logger(PathsWatcher.class).info("registering action %d for monitoring %s in %s", System.identityHashCode(action), sourceFile, directory);
            Map fileAction = this.filesActions.computeIfAbsent(directory.toString(), p -> {
                try {
                    directory.register(this.watchService, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE}, SensitivityWatchEventModifier.HIGH);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return new HashMap();
            });
            List actions = fileAction.computeIfAbsent(sourceFile.toString(), k -> new LinkedList());
            actions.add(action);
            CSSFXLogger.logger(PathsWatcher.class).debug("%d CSS modification actions registered for file %s", actions.size(), sourceFile);
        } else {
            CSSFXLogger.logger(PathsWatcher.class).warn("no WatchService active, CSS monitoring cannot occur", new Object[0]);
        }
    }

    public void unregister(Path directory, Path sourceFile, Runnable action) {
        this.filesActions.get(directory.toString()).get(sourceFile.toString()).remove(action);
    }

    public void watch() {
        this.watcherThread = new Thread(new Runnable(){

            @Override
            public void run() {
                WatchKey key;
                boolean valid;
                CSSFXLogger.logger(PathsWatcher.class).info("starting to monitor physical files", new Object[0]);
                do {
                    try {
                        key = PathsWatcher.this.watchService.take();
                    }
                    catch (InterruptedException ex) {
                        return;
                    }
                    Path directory = ((Path)key.watchable()).toAbsolutePath().normalize();
                    for (WatchEvent<?> event : key.pollEvents()) {
                        WatchEvent.Kind<?> kind = event.kind();
                        CSSFXLogger.logger(PathsWatcher.class).debug("'%s' change detected in directory %s", kind, directory);
                        if (kind != StandardWatchEventKinds.ENTRY_MODIFY && kind != StandardWatchEventKinds.ENTRY_CREATE && kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                        WatchEvent<?> ev = event;
                        Path modifiedFile = directory.resolve((Path)ev.context()).toAbsolutePath().normalize();
                        if (!PathsWatcher.this.filesActions.containsKey(directory.toString())) continue;
                        CSSFXLogger.logger(PathsWatcher.class).debug("file: %s was modified", modifiedFile.getFileName());
                        Map<String, List<Runnable>> filesAction = PathsWatcher.this.filesActions.get(directory.toString());
                        if (filesAction.containsKey(modifiedFile.toString())) {
                            CSSFXLogger.logger(PathsWatcher.class).debug("file is monitored", new Object[0]);
                            List<Runnable> actions = filesAction.get(modifiedFile.toString());
                            CSSFXLogger.logger(PathsWatcher.class).debug("%d CSS modification will be performed ", actions.size());
                            for (Runnable action : actions) {
                                action.run();
                            }
                            continue;
                        }
                        CSSFXLogger.logger(PathsWatcher.class).debug("file is not monitored", new Object[0]);
                    }
                } while (valid = key.reset());
            }
        }, "CSSFX-file-monitor");
        this.watcherThread.setDaemon(true);
        this.watcherThread.start();
    }

    public void stop() {
        this.watcherThread.interrupt();
    }
}

