/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.cssfx;

import fr.brouillard.oss.cssfx.api.URIToPathConverter;
import fr.brouillard.oss.cssfx.impl.CSSFXMonitor;
import fr.brouillard.oss.cssfx.impl.URIToPathConverters;
import fr.brouillard.oss.cssfx.impl.log.CSSFXLogger;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.stage.Window;

public class CSSFX {
    private static boolean isCssFXStarted = false;

    public static synchronized Runnable start() {
        if (!isCssFXStarted) {
            isCssFXStarted = true;
            return new CSSFXConfig().start();
        }
        return () -> {};
    }

    public static Runnable start(Window window) {
        CSSFXConfig cfg = new CSSFXConfig();
        cfg.setRestrictedToWindow(window);
        return cfg.start();
    }

    public static Runnable start(Scene scene) {
        CSSFXConfig cfg = new CSSFXConfig();
        cfg.setRestrictedToScene(scene);
        return cfg.start();
    }

    public static Runnable start(Node node) {
        CSSFXConfig cfg = new CSSFXConfig();
        cfg.setRestrictedToNode(node);
        return cfg.start();
    }

    public static CSSFXConfig onlyFor(Window window) {
        CSSFXConfig cfg = new CSSFXConfig();
        cfg.setRestrictedToWindow(window);
        return cfg;
    }

    public static CSSFXConfig onlyFor(Scene s) {
        CSSFXConfig cfg = new CSSFXConfig();
        cfg.setRestrictedToScene(s);
        return cfg;
    }

    public static CSSFXConfig onlyFor(Node n) {
        CSSFXConfig cfg = new CSSFXConfig();
        cfg.setRestrictedToNode(n);
        return cfg;
    }

    public static CSSFXConfig addConverter(URIToPathConverter converter) {
        return new CSSFXConfig().addConverter(converter);
    }

    public static class CSSFXConfig {
        private final Set<URIToPathConverter> converters = new LinkedHashSet<URIToPathConverter>(Arrays.asList(URIToPathConverters.DEFAULT_CONVERTERS));
        private Window restrictedToWindow = null;
        private Scene restrictedToScene = null;
        private Node restrictedToNode = null;

        CSSFXConfig() {
        }

        void setRestrictedToWindow(Window restrictedToWindow) {
            this.restrictedToWindow = restrictedToWindow;
        }

        void setRestrictedToScene(Scene restrictedToScene) {
            this.restrictedToScene = restrictedToScene;
        }

        void setRestrictedToNode(Node restrictedToNode) {
            this.restrictedToNode = restrictedToNode;
        }

        public CSSFXConfig noDefaultConverters() {
            this.converters.clear();
            return this;
        }

        public CSSFXConfig addConverter(URIToPathConverter converter) {
            this.converters.add(converter);
            return this;
        }

        public Runnable start() {
            if (Boolean.getBoolean("cssfx.disable")) {
                System.out.println("CSSFX was not started, because it's disabled via the system property 'cssfx.disable'");
                return () -> {};
            }
            if (!CSSFXLogger.isInitialized()) {
                if (Boolean.getBoolean("cssfx.log")) {
                    String logType;
                    CSSFXLogger.LogLevel toActivate = CSSFXLogger.LogLevel.INFO;
                    String levelStr = System.getProperty("cssfx.log.level", "INFO");
                    try {
                        toActivate = CSSFXLogger.LogLevel.valueOf(levelStr);
                    }
                    catch (Exception ignore) {
                        System.err.println("[CSSFX] invalid value for cssfx.log.level, '" + levelStr + "' is not allowed. Select one in: " + Arrays.asList(CSSFXLogger.LogLevel.values()));
                    }
                    CSSFXLogger.setLogLevel(toActivate);
                    switch (logType = System.getProperty("cssfx.log.type", "console")) {
                        case "noop": {
                            CSSFXLogger.noop();
                            break;
                        }
                        case "console": {
                            CSSFXLogger.console();
                            break;
                        }
                        case "jul": {
                            CSSFXLogger.jul();
                            break;
                        }
                        default: {
                            System.err.println("[CSSFX] invalid value for cssfx.log.type, '" + logType + "' is not allowed. Select one in: " + Arrays.asList("noop", "console", "jul"));
                            break;
                        }
                    }
                } else {
                    CSSFXLogger.noop();
                }
            }
            CSSFXMonitor m = new CSSFXMonitor();
            if (this.restrictedToWindow != null) {
                m.setWindows((ObservableList<? extends Window>)FXCollections.singletonObservableList((Object)this.restrictedToWindow));
            } else if (this.restrictedToScene != null) {
                m.setScenes((ObservableList<Scene>)FXCollections.singletonObservableList((Object)this.restrictedToScene));
            } else if (this.restrictedToNode != null) {
                m.setNodes((ObservableList<Node>)FXCollections.singletonObservableList((Object)this.restrictedToNode));
            } else {
                ObservableList monitoredStages = this.restrictedToWindow == null ? Window.getWindows() : FXCollections.singletonObservableList((Object)this.restrictedToWindow);
                m.setWindows((ObservableList<? extends Window>)monitoredStages);
            }
            return this.start(() -> m);
        }

        private Runnable start(Callable<CSSFXMonitor> monitorBuilder) {
            try {
                CSSFXMonitor mon = monitorBuilder.call();
                mon.addAllConverters(this.converters);
                mon.start();
                return mon::stop;
            }
            catch (Exception e) {
                throw new RuntimeException("could not create CSSFXMonitor", e);
            }
        }
    }
}

