/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.commonmark.ext.notifications;

import fr.brouillard.oss.commonmark.ext.notifications.Notification;
import fr.brouillard.oss.commonmark.ext.notifications.NotificationBlock;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import org.commonmark.node.Node;
import org.commonmark.renderer.NodeRenderer;
import org.commonmark.renderer.html.HtmlNodeRendererContext;
import org.commonmark.renderer.html.HtmlWriter;

public class NotificationNodeRenderer
implements NodeRenderer {
    private final HtmlNodeRendererContext context;
    private final HtmlWriter htmlWriter;

    public NotificationNodeRenderer(HtmlNodeRendererContext context) {
        this.context = context;
        this.htmlWriter = context.getWriter();
    }

    public Set<Class<? extends Node>> getNodeTypes() {
        return Collections.singleton(NotificationBlock.class);
    }

    public void render(Node node) {
        NotificationBlock nb = (NotificationBlock)node;
        this.htmlWriter.line();
        this.htmlWriter.tag("div", Collections.singletonMap("class", NotificationNodeRenderer.classOf(nb.getType())));
        this.renderChildren((Node)nb);
        this.htmlWriter.tag("/div");
        this.htmlWriter.line();
    }

    private void renderChildren(Node parent) {
        Node node = parent.getFirstChild();
        while (node != null) {
            Node next = node.getNext();
            this.context.render(node);
            node = next;
        }
    }

    private static String classOf(Notification n) {
        return "notification_" + n.name().toLowerCase(Locale.ENGLISH);
    }
}

