/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.commonmark.ext.notifications;

import fr.brouillard.oss.commonmark.ext.notifications.Notification;
import fr.brouillard.oss.commonmark.ext.notifications.NotificationBlock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.commonmark.node.Block;
import org.commonmark.parser.block.AbstractBlockParser;
import org.commonmark.parser.block.AbstractBlockParserFactory;
import org.commonmark.parser.block.BlockContinue;
import org.commonmark.parser.block.BlockParser;
import org.commonmark.parser.block.BlockStart;
import org.commonmark.parser.block.MatchedBlockParser;
import org.commonmark.parser.block.ParserState;

public class NotificationBlockParser
extends AbstractBlockParser {
    private static final Pattern NOTIFICATIONS_LINE = Pattern.compile("\\s*!([v!x]?)\\s(.*)");
    private final NotificationBlock block;
    private Notification type;

    public NotificationBlockParser(Notification type) {
        this.type = type;
        this.block = new NotificationBlock(type);
    }

    public boolean isContainer() {
        return true;
    }

    public boolean canContain(Block block) {
        return block != null && !NotificationBlock.class.isAssignableFrom(block.getClass());
    }

    public Block getBlock() {
        return this.block;
    }

    public BlockContinue tryContinue(ParserState state) {
        CharSequence fullLine = state.getLine();
        CharSequence currentLine = fullLine.subSequence(state.getColumn() + state.getIndent(), fullLine.length());
        Matcher matcher = NOTIFICATIONS_LINE.matcher(currentLine);
        if (matcher.matches() && this.type.equals((Object)Notification.fromString(matcher.group(1)))) {
            return BlockContinue.atColumn((int)(state.getColumn() + state.getIndent() + matcher.start(2)));
        }
        return BlockContinue.none();
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            CharSequence fullLine = state.getLine();
            CharSequence line = fullLine.subSequence(state.getColumn(), fullLine.length());
            Matcher matcher = NOTIFICATIONS_LINE.matcher(line);
            if (matcher.matches()) {
                return BlockStart.of((BlockParser[])new BlockParser[]{new NotificationBlockParser(Notification.fromString(matcher.group(1)))}).atColumn(state.getColumn() + state.getIndent() + matcher.start(2));
            }
            return BlockStart.none();
        }
    }
}

