/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.json;

import fish.payara.arquillian.javax.json.JsonArray;
import fish.payara.arquillian.javax.json.JsonException;
import fish.payara.arquillian.javax.json.JsonObject;
import fish.payara.arquillian.javax.json.JsonReader;
import fish.payara.arquillian.javax.json.JsonStructure;
import fish.payara.arquillian.javax.json.JsonValue;
import fish.payara.arquillian.javax.json.stream.JsonParser;
import fish.payara.arquillian.javax.json.stream.JsonParsingException;
import fish.payara.arquillian.json.JsonMessages;
import fish.payara.arquillian.json.JsonParserImpl;
import fish.payara.arquillian.json.api.BufferPool;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;

class JsonReaderImpl
implements JsonReader {
    private final JsonParserImpl parser;
    private boolean readDone;
    private final BufferPool bufferPool;

    JsonReaderImpl(Reader reader, BufferPool bufferPool) {
        this.parser = new JsonParserImpl(reader, bufferPool);
        this.bufferPool = bufferPool;
    }

    JsonReaderImpl(InputStream in, BufferPool bufferPool) {
        this.parser = new JsonParserImpl(in, bufferPool);
        this.bufferPool = bufferPool;
    }

    JsonReaderImpl(InputStream in, Charset charset, BufferPool bufferPool) {
        this.parser = new JsonParserImpl(in, charset, bufferPool);
        this.bufferPool = bufferPool;
    }

    @Override
    public JsonStructure read() {
        if (this.readDone) {
            throw new IllegalStateException(JsonMessages.READER_READ_ALREADY_CALLED());
        }
        this.readDone = true;
        if (this.parser.hasNext()) {
            try {
                JsonParser.Event e = this.parser.next();
                if (e == JsonParser.Event.START_ARRAY) {
                    return this.parser.getArray();
                }
                if (e == JsonParser.Event.START_OBJECT) {
                    return this.parser.getObject();
                }
            }
            catch (IllegalStateException ise) {
                throw new JsonParsingException(ise.getMessage(), ise, this.parser.getLastCharLocation());
            }
        }
        throw new JsonException(JsonMessages.INTERNAL_ERROR());
    }

    @Override
    public JsonObject readObject() {
        if (this.readDone) {
            throw new IllegalStateException(JsonMessages.READER_READ_ALREADY_CALLED());
        }
        this.readDone = true;
        if (this.parser.hasNext()) {
            try {
                this.parser.next();
                return this.parser.getObject();
            }
            catch (IllegalStateException ise) {
                throw new JsonParsingException(ise.getMessage(), ise, this.parser.getLastCharLocation());
            }
        }
        throw new JsonException(JsonMessages.INTERNAL_ERROR());
    }

    @Override
    public JsonArray readArray() {
        if (this.readDone) {
            throw new IllegalStateException(JsonMessages.READER_READ_ALREADY_CALLED());
        }
        this.readDone = true;
        if (this.parser.hasNext()) {
            try {
                this.parser.next();
                return this.parser.getArray();
            }
            catch (IllegalStateException ise) {
                throw new JsonParsingException(ise.getMessage(), ise, this.parser.getLastCharLocation());
            }
        }
        throw new JsonException(JsonMessages.INTERNAL_ERROR());
    }

    @Override
    public JsonValue readValue() {
        if (this.readDone) {
            throw new IllegalStateException(JsonMessages.READER_READ_ALREADY_CALLED());
        }
        this.readDone = true;
        if (this.parser.hasNext()) {
            try {
                this.parser.next();
                return this.parser.getValue();
            }
            catch (IllegalStateException ise) {
                throw new JsonParsingException(ise.getMessage(), ise, this.parser.getLastCharLocation());
            }
        }
        throw new JsonException(JsonMessages.INTERNAL_ERROR());
    }

    @Override
    public void close() {
        this.readDone = true;
        this.parser.close();
    }
}

