/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.jersey.server.wadl.processor;

import fish.payara.arquillian.annotation.Priority;
import fish.payara.arquillian.inject.Inject;
import fish.payara.arquillian.inject.Provider;
import fish.payara.arquillian.jersey.internal.util.PropertiesHelper;
import fish.payara.arquillian.jersey.message.internal.MediaTypes;
import fish.payara.arquillian.jersey.process.Inflector;
import fish.payara.arquillian.jersey.server.ExtendedUriInfo;
import fish.payara.arquillian.jersey.server.model.ModelProcessor;
import fish.payara.arquillian.jersey.server.model.Resource;
import fish.payara.arquillian.jersey.server.model.ResourceModel;
import fish.payara.arquillian.jersey.server.model.RuntimeResource;
import fish.payara.arquillian.jersey.server.model.internal.ModelProcessorUtil;
import fish.payara.arquillian.jersey.server.wadl.WadlApplicationContext;
import fish.payara.arquillian.jersey.server.wadl.internal.WadlResource;
import fish.payara.arquillian.jersey.server.wadl.internal.WadlUtils;
import fish.payara.arquillian.research.ws.wadl.Application;
import fish.payara.arquillian.ws.rs.ProcessingException;
import fish.payara.arquillian.ws.rs.container.ContainerRequestContext;
import fish.payara.arquillian.ws.rs.core.Configuration;
import fish.payara.arquillian.ws.rs.core.Context;
import fish.payara.arquillian.ws.rs.core.MediaType;
import fish.payara.arquillian.ws.rs.core.Response;
import fish.payara.arquillian.ws.rs.core.UriInfo;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.Marshaller;

@Priority(value=10000)
public class WadlModelProcessor
implements ModelProcessor {
    private final List<ModelProcessorUtil.Method> methodList = new ArrayList<ModelProcessorUtil.Method>();

    public WadlModelProcessor() {
        this.methodList.add(new ModelProcessorUtil.Method("OPTIONS", MediaType.WILDCARD_TYPE, MediaTypes.WADL_TYPE, OptionsHandler.class));
    }

    @Override
    public ResourceModel processResourceModel(ResourceModel resourceModel, Configuration configuration) {
        boolean disabled = PropertiesHelper.isProperty(configuration.getProperty("jersey.config.server.wadl.disableWadl"));
        if (disabled) {
            return resourceModel;
        }
        ResourceModel.Builder builder = ModelProcessorUtil.enhanceResourceModel(resourceModel, false, this.methodList, true);
        if (!configuration.getClasses().contains(WadlResource.class)) {
            Resource wadlResource = Resource.builder(WadlResource.class).build();
            builder.addResource(wadlResource);
        }
        return builder.build();
    }

    @Override
    public ResourceModel processSubResource(ResourceModel resourceModel, Configuration configuration) {
        boolean disabled = PropertiesHelper.isProperty(configuration.getProperty("jersey.config.server.wadl.disableWadl"));
        if (disabled) {
            return resourceModel;
        }
        return ModelProcessorUtil.enhanceResourceModel(resourceModel, true, this.methodList, true).build();
    }

    public static class OptionsHandler
    implements Inflector<ContainerRequestContext, Response> {
        private final String lastModified = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz").format(new Date());
        @Inject
        private Provider<ExtendedUriInfo> extendedUriInfo;
        @Context
        private WadlApplicationContext wadlApplicationContext;

        @Override
        public Response apply(ContainerRequestContext containerRequestContext) {
            byte[] bytes;
            RuntimeResource resource = this.extendedUriInfo.get().getMatchedRuntimeResources().get(0);
            UriInfo uriInfo = containerRequestContext.getUriInfo();
            Application wadlApplication = this.wadlApplicationContext.getApplication(uriInfo, resource.getResources().get(0), WadlUtils.isDetailedWadlRequested(uriInfo));
            if (wadlApplication == null) {
                return Response.status(Response.Status.NOT_FOUND).build();
            }
            try {
                Marshaller marshaller = this.wadlApplicationContext.getJAXBContext().createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                marshaller.marshal((Object)wadlApplication, (OutputStream)os);
                bytes = os.toByteArray();
                os.close();
            }
            catch (Exception e) {
                throw new ProcessingException("Could not marshal the wadl Application.", e);
            }
            return Response.ok().type(MediaTypes.WADL_TYPE).allow(ModelProcessorUtil.getAllowedMethods(resource)).header("Last-modified", this.lastModified).entity(bytes).build();
        }
    }
}

