/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.jersey.server.internal.process;

import fish.payara.arquillian.jersey.internal.inject.InjectionManager;
import fish.payara.arquillian.jersey.internal.util.collection.Ref;
import fish.payara.arquillian.jersey.internal.util.collection.Refs;
import fish.payara.arquillian.jersey.internal.util.collection.Value;
import fish.payara.arquillian.jersey.internal.util.collection.Values;
import fish.payara.arquillian.jersey.process.internal.ChainableStage;
import fish.payara.arquillian.jersey.process.internal.Stage;
import fish.payara.arquillian.jersey.server.AsyncContext;
import fish.payara.arquillian.jersey.server.CloseableService;
import fish.payara.arquillian.jersey.server.ContainerRequest;
import fish.payara.arquillian.jersey.server.ContainerResponse;
import fish.payara.arquillian.jersey.server.internal.monitoring.RequestEventBuilder;
import fish.payara.arquillian.jersey.server.internal.process.DefaultCloseableService;
import fish.payara.arquillian.jersey.server.internal.process.DefaultRespondingContext;
import fish.payara.arquillian.jersey.server.internal.process.RespondingContext;
import fish.payara.arquillian.jersey.server.internal.routing.RoutingContext;
import fish.payara.arquillian.jersey.server.internal.routing.UriRoutingContext;
import fish.payara.arquillian.jersey.server.monitoring.RequestEvent;
import fish.payara.arquillian.jersey.server.monitoring.RequestEventListener;
import java.util.function.Function;

public final class RequestProcessingContext
implements RespondingContext {
    private final InjectionManager injectionManager;
    private final ContainerRequest request;
    private final UriRoutingContext routingContext;
    private final RespondingContext respondingContext;
    private final CloseableService closeableService;
    private final RequestEventBuilder monitoringEventBuilder;
    private final RequestEventListener monitoringEventListener;
    private final Ref<Value<AsyncContext>> asyncContextValueRef;

    public RequestProcessingContext(InjectionManager injectionManager, ContainerRequest request, UriRoutingContext routingContext, RequestEventBuilder monitoringEventBuilder, RequestEventListener monitoringEventListener) {
        this.injectionManager = injectionManager;
        this.request = request;
        this.routingContext = routingContext;
        this.respondingContext = new DefaultRespondingContext();
        this.closeableService = new DefaultCloseableService();
        this.monitoringEventBuilder = monitoringEventBuilder;
        this.monitoringEventListener = monitoringEventListener;
        this.asyncContextValueRef = Refs.threadSafe(Values.empty());
    }

    public ContainerRequest request() {
        return this.request;
    }

    public RoutingContext routingContext() {
        return this.routingContext;
    }

    UriRoutingContext uriRoutingContext() {
        return this.routingContext;
    }

    public CloseableService closeableService() {
        return this.closeableService;
    }

    public void initAsyncContext(Value<AsyncContext> lazyContextValue) {
        this.asyncContextValueRef.set(Values.lazy(lazyContextValue));
    }

    public AsyncContext asyncContext() {
        return (AsyncContext)((Value)this.asyncContextValueRef.get()).get();
    }

    public Value<AsyncContext> asyncContextValue() {
        return (Value)this.asyncContextValueRef.get();
    }

    public InjectionManager injectionManager() {
        return this.injectionManager;
    }

    public RequestEventBuilder monitoringEventBuilder() {
        return this.monitoringEventBuilder;
    }

    public void triggerEvent(RequestEvent.Type eventType) {
        if (this.monitoringEventListener != null) {
            this.monitoringEventListener.onEvent(this.monitoringEventBuilder.build(eventType));
        }
    }

    @Override
    public void push(Function<ContainerResponse, ContainerResponse> responseTransformation) {
        this.respondingContext.push(responseTransformation);
    }

    @Override
    public void push(ChainableStage<ContainerResponse> stage) {
        this.respondingContext.push(stage);
    }

    @Override
    public Stage<ContainerResponse> createRespondingRoot() {
        return this.respondingContext.createRespondingRoot();
    }
}

