/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.jersey.server.internal.inject;

import fish.payara.arquillian.inject.Provider;
import fish.payara.arquillian.inject.Singleton;
import fish.payara.arquillian.jersey.model.Parameter;
import fish.payara.arquillian.jersey.server.ContainerRequest;
import fish.payara.arquillian.jersey.server.internal.LocalizationMessages;
import fish.payara.arquillian.jersey.server.internal.inject.AbstractValueParamProvider;
import fish.payara.arquillian.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import fish.payara.arquillian.jersey.server.model.Parameter;
import fish.payara.arquillian.ws.rs.BadRequestException;
import fish.payara.arquillian.ws.rs.container.ContainerRequestContext;
import fish.payara.arquillian.ws.rs.core.Request;
import fish.payara.arquillian.ws.rs.core.Response;
import java.util.function.Function;

@Singleton
class EntityParamValueParamProvider
extends AbstractValueParamProvider {
    EntityParamValueParamProvider(Provider<MultivaluedParameterExtractorProvider> mpep) {
        super(mpep, Parameter.Source.ENTITY);
    }

    @Override
    protected Function<ContainerRequest, ?> createValueProvider(Parameter parameter) {
        return new EntityValueSupplier(parameter);
    }

    private static class EntityValueSupplier
    implements Function<ContainerRequest, Object> {
        private final Parameter parameter;

        public EntityValueSupplier(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public Object apply(ContainerRequest containerRequest) {
            ContainerRequest value;
            Class<?> rawType = this.parameter.getRawType();
            if ((Request.class.isAssignableFrom(rawType) || ContainerRequestContext.class.isAssignableFrom(rawType)) && rawType.isInstance(containerRequest)) {
                value = containerRequest;
            } else {
                value = containerRequest.readEntity(rawType, this.parameter.getType(), this.parameter.getAnnotations());
                if (rawType.isPrimitive() && value == null) {
                    throw new BadRequestException(Response.status(Response.Status.BAD_REQUEST).entity(LocalizationMessages.ERROR_PRIMITIVE_TYPE_NULL()).build());
                }
            }
            return value;
        }
    }
}

