/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.jersey.server;

import fish.payara.arquillian.jersey.internal.BootstrapBag;
import fish.payara.arquillian.jersey.internal.BootstrapConfigurator;
import fish.payara.arquillian.jersey.internal.ServiceFinder;
import fish.payara.arquillian.jersey.internal.inject.AbstractBinder;
import fish.payara.arquillian.jersey.internal.inject.InjectionManager;
import fish.payara.arquillian.jersey.server.ServerBootstrapBag;
import fish.payara.arquillian.jersey.server.internal.LocalizationMessages;
import fish.payara.arquillian.jersey.server.spi.ComponentProvider;
import fish.payara.arquillian.jersey.server.spi.ExternalRequestContext;
import fish.payara.arquillian.jersey.server.spi.ExternalRequestScope;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;

class ExternalRequestScopeConfigurator
implements BootstrapConfigurator {
    private static final Logger LOGGER = Logger.getLogger(ExternalRequestScopeConfigurator.class.getName());
    private static final ExternalRequestScope<Object> NOOP_EXTERNAL_REQ_SCOPE = new ExternalRequestScope<Object>(){

        @Override
        public ExternalRequestContext<Object> open(InjectionManager injectionManager) {
            return null;
        }

        @Override
        public void close() {
        }

        @Override
        public void suspend(ExternalRequestContext<Object> o, InjectionManager injectionManager) {
        }

        @Override
        public void resume(ExternalRequestContext<Object> o, InjectionManager injectionManager) {
        }
    };

    ExternalRequestScopeConfigurator() {
    }

    @Override
    public void init(InjectionManager injectionManager, BootstrapBag bootstrapBag) {
        ServerBootstrapBag serverBag = (ServerBootstrapBag)bootstrapBag;
        Class<ExternalRequestScope>[] extScopes = ServiceFinder.find(ExternalRequestScope.class, true).toClassArray();
        boolean extScopeBound = false;
        if (extScopes.length == 1) {
            for (ComponentProvider p : (Collection)serverBag.getComponentProviders().get()) {
                if (!p.bind(extScopes[0], Collections.singleton(ExternalRequestScope.class))) continue;
                extScopeBound = true;
                break;
            }
        } else if (extScopes.length > 1 && LOGGER.isLoggable(Level.WARNING)) {
            StringBuilder scopeList = new StringBuilder("\n");
            for (Class<ExternalRequestScope> ers : extScopes) {
                scopeList.append("   ").append(ers.getTypeParameters()[0]).append('\n');
            }
            LOGGER.warning(LocalizationMessages.WARNING_TOO_MANY_EXTERNAL_REQ_SCOPES(scopeList.toString()));
        }
        if (!extScopeBound) {
            injectionManager.register(new NoopExternalRequestScopeBinder());
        }
    }

    private static class NoopExternalRequestScopeBinder
    extends AbstractBinder {
        private NoopExternalRequestScopeBinder() {
        }

        @Override
        protected void configure() {
            this.bind(NOOP_EXTERNAL_REQ_SCOPE).to(ExternalRequestScope.class);
        }
    }
}

