/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.jersey.server;

import fish.payara.arquillian.inject.Singleton;
import fish.payara.arquillian.jersey.internal.BootstrapBag;
import fish.payara.arquillian.jersey.internal.BootstrapConfigurator;
import fish.payara.arquillian.jersey.internal.inject.Binding;
import fish.payara.arquillian.jersey.internal.inject.Bindings;
import fish.payara.arquillian.jersey.internal.inject.InjectionManager;
import fish.payara.arquillian.jersey.internal.util.collection.Value;
import fish.payara.arquillian.jersey.server.ResourceConfig;
import fish.payara.arquillian.jersey.server.ServerBootstrapBag;
import fish.payara.arquillian.jersey.server.spi.ComponentProvider;
import fish.payara.arquillian.ws.rs.core.Application;
import java.util.Collection;
import java.util.Collections;

class ApplicationConfigurator
implements BootstrapConfigurator {
    private Application application;
    private Class<? extends Application> applicationClass;

    ApplicationConfigurator(Application application) {
        this.application = application;
    }

    ApplicationConfigurator(Class<? extends Application> applicationClass) {
        this.applicationClass = applicationClass;
    }

    @Override
    public void init(InjectionManager injectionManager, BootstrapBag bootstrapBag) {
        Application resultApplication;
        ServerBootstrapBag serverBag = (ServerBootstrapBag)bootstrapBag;
        if (this.application != null) {
            ResourceConfig rc;
            if (this.application instanceof ResourceConfig && (rc = (ResourceConfig)this.application).getApplicationClass() != null) {
                rc.setApplication(ApplicationConfigurator.createApplication(injectionManager, rc.getApplicationClass(), serverBag.getComponentProviders()));
            }
            resultApplication = this.application;
        } else {
            resultApplication = ApplicationConfigurator.createApplication(injectionManager, this.applicationClass, serverBag.getComponentProviders());
        }
        serverBag.setApplication(resultApplication);
        injectionManager.register((Binding)Bindings.service(resultApplication).to(Application.class));
    }

    private static Application createApplication(InjectionManager injectionManager, Class<? extends Application> applicationClass, Value<Collection<ComponentProvider>> componentProvidersValue) {
        ResourceConfig _rc;
        Class<? extends Application> innerAppClass;
        Application app;
        if (applicationClass == ResourceConfig.class) {
            return new ResourceConfig();
        }
        if (applicationClass == Application.class) {
            return new Application();
        }
        Collection<ComponentProvider> componentProviders = componentProvidersValue.get();
        boolean appClassBound = false;
        for (ComponentProvider cp : componentProviders) {
            if (!cp.bind(applicationClass, Collections.emptySet())) continue;
            appClassBound = true;
            break;
        }
        if (!appClassBound && applicationClass.isAnnotationPresent(Singleton.class)) {
            injectionManager.register((Binding)Bindings.serviceAsContract(applicationClass).in(Singleton.class));
            appClassBound = true;
        }
        Application application = app = appClassBound ? injectionManager.getInstance(applicationClass) : injectionManager.createAndInitialize(applicationClass);
        if (app instanceof ResourceConfig && (innerAppClass = (_rc = (ResourceConfig)app).getApplicationClass()) != null) {
            Application innerApp = ApplicationConfigurator.createApplication(injectionManager, innerAppClass, componentProvidersValue);
            _rc.setApplication(innerApp);
        }
        return app;
    }
}

