/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.jersey.media.sse;

import fish.payara.arquillian.jersey.internal.util.Property;
import fish.payara.arquillian.jersey.media.sse.EventInputReader;
import fish.payara.arquillian.jersey.media.sse.InboundEventReader;
import fish.payara.arquillian.jersey.media.sse.OutboundEventWriter;
import fish.payara.arquillian.jersey.media.sse.internal.SseBinder;
import fish.payara.arquillian.jersey.media.sse.internal.SseEventSinkValueParamProvider;
import fish.payara.arquillian.jersey.server.spi.internal.ValueParamProvider;
import fish.payara.arquillian.ws.rs.core.Configurable;
import fish.payara.arquillian.ws.rs.core.Feature;
import fish.payara.arquillian.ws.rs.core.FeatureContext;
import fish.payara.arquillian.ws.rs.core.MediaType;

public class SseFeature
implements Feature {
    public static final String SERVER_SENT_EVENTS = "text/event-stream";
    public static final MediaType SERVER_SENT_EVENTS_TYPE = MediaType.valueOf("text/event-stream");
    @Property
    public static final String DISABLE_SSE = "jersey.config.media.sse.disable";
    @Property
    public static final String DISABLE_SSE_CLIENT = "jersey.config.client.media.sse.disable";
    @Property
    public static final String DISABLE_SSE_SERVER = "jersey.config.server.media.sse.disable";
    public static final long RECONNECT_NOT_SET = -1L;
    public static final String LAST_EVENT_ID_HEADER = "Last-Event-ID";

    @Override
    public boolean configure(FeatureContext context) {
        if (context.getConfiguration().isEnabled(this.getClass())) {
            return false;
        }
        switch (context.getConfiguration().getRuntimeType()) {
            case CLIENT: {
                context.register(EventInputReader.class);
                context.register(InboundEventReader.class);
                break;
            }
            case SERVER: {
                context.register(OutboundEventWriter.class);
                context.register(new SseBinder());
                context.register(SseEventSinkValueParamProvider.class, ValueParamProvider.class);
            }
        }
        return true;
    }

    static <T extends Configurable<T>> T register(T ctx) {
        if (!ctx.getConfiguration().isRegistered(SseFeature.class)) {
            ctx.register(SseFeature.class);
        }
        return ctx;
    }
}

