/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.faster.jackson.databind.util;

import fish.payara.arquillian.faster.jackson.databind.AnnotationIntrospector;
import fish.payara.arquillian.faster.jackson.databind.BeanDescription;
import fish.payara.arquillian.faster.jackson.databind.JavaType;
import fish.payara.arquillian.faster.jackson.databind.PropertyName;
import fish.payara.arquillian.faster.jackson.databind.cfg.MapperConfig;
import fish.payara.arquillian.faster.jackson.databind.introspect.AnnotatedClass;
import fish.payara.arquillian.faster.jackson.databind.type.ClassKey;
import fish.payara.arquillian.faster.jackson.databind.util.LRUMap;
import java.io.Serializable;

public class RootNameLookup
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient LRUMap<ClassKey, PropertyName> _rootNames = new LRUMap(20, 200);

    public PropertyName findRootName(JavaType rootType, MapperConfig<?> config) {
        return this.findRootName(rootType.getRawClass(), config);
    }

    public PropertyName findRootName(Class<?> rootType, MapperConfig<?> config) {
        AnnotatedClass ac;
        ClassKey key = new ClassKey(rootType);
        PropertyName name = this._rootNames.get(key);
        if (name != null) {
            return name;
        }
        BeanDescription beanDesc = config.introspectClassAnnotations(rootType);
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        name = intr.findRootName(ac = beanDesc.getClassInfo());
        if (name == null || !name.hasSimpleName()) {
            name = PropertyName.construct(rootType.getSimpleName());
        }
        this._rootNames.put(key, name);
        return name;
    }

    protected Object readResolve() {
        return new RootNameLookup();
    }
}

